@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetMediaServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 */
public data class GetMediaServicePlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetMediaServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetMediaServicePlainArgs =
        com.pulumi.azurenative.media.inputs.GetMediaServicePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMediaServicePlainArgs].
 */
@PulumiTagMarker
public class GetMediaServicePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("toskkramhpkvqrrn")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("limhhblesdmemyyv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMediaServicePlainArgs = GetMediaServicePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
