@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetStreamingEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property streamingEndpointName The name of the streaming endpoint, maximum length is 24.
 */
public data class GetStreamingEndpointPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val streamingEndpointName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetStreamingEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetStreamingEndpointPlainArgs =
        com.pulumi.azurenative.media.inputs.GetStreamingEndpointPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .streamingEndpointName(streamingEndpointName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStreamingEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetStreamingEndpointPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var streamingEndpointName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("mjmklajsymciqgol")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("yipisgtmdeiesnoh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the streaming endpoint, maximum length is 24.
     */
    @JvmName("risffcjirydqvykv")
    public suspend fun streamingEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.streamingEndpointName = mapped
    }

    internal fun build(): GetStreamingEndpointPlainArgs = GetStreamingEndpointPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        streamingEndpointName = streamingEndpointName ?: throw
            PulumiNullFieldException("streamingEndpointName"),
    )
}
