@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.GetStreamingPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The Media Services account name.
 * @property resourceGroupName The name of the resource group within the Azure subscription.
 * @property streamingPolicyName The Streaming Policy name.
 */
public data class GetStreamingPolicyPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val streamingPolicyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.GetStreamingPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.GetStreamingPolicyPlainArgs =
        com.pulumi.azurenative.media.inputs.GetStreamingPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .streamingPolicyName(streamingPolicyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStreamingPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetStreamingPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var streamingPolicyName: String? = null

    /**
     * @param value The Media Services account name.
     */
    @JvmName("pirmmlypwqhckyfv")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the Azure subscription.
     */
    @JvmName("hldybyuhoehbnsim")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Streaming Policy name.
     */
    @JvmName("txvbsolmbfddaxjb")
    public suspend fun streamingPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.streamingPolicyName = mapped
    }

    internal fun build(): GetStreamingPolicyPlainArgs = GetStreamingPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        streamingPolicyName = streamingPolicyName ?: throw PulumiNullFieldException("streamingPolicyName"),
    )
}
