@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.H264VideoArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.H264Complexity
import com.pulumi.azurenative.media.kotlin.enums.H264RateControlMode
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.azurenative.media.kotlin.enums.VideoSyncMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes all the properties for encoding a video with the H.264 codec.
 * @property complexity Tells the encoder how to choose its encoding settings. The default value is Balanced.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers The collection of output H.264 layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.H264Video'.
 * @property rateControlMode The video rate control mode
 * @property sceneChangeDetection Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class H264VideoArgs(
    public val complexity: Output<Either<String, H264Complexity>>? = null,
    public val keyFrameInterval: Output<String>? = null,
    public val label: Output<String>? = null,
    public val layers: Output<List<H264LayerArgs>>? = null,
    public val odataType: Output<String>,
    public val rateControlMode: Output<Either<String, H264RateControlMode>>? = null,
    public val sceneChangeDetection: Output<Boolean>? = null,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
    public val syncMode: Output<Either<String, VideoSyncMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.H264VideoArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.H264VideoArgs =
        com.pulumi.azurenative.media.inputs.H264VideoArgs.builder()
            .complexity(
                complexity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .rateControlMode(
                rateControlMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sceneChangeDetection(sceneChangeDetection?.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncMode(
                syncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [H264VideoArgs].
 */
@PulumiTagMarker
public class H264VideoArgsBuilder internal constructor() {
    private var complexity: Output<Either<String, H264Complexity>>? = null

    private var keyFrameInterval: Output<String>? = null

    private var label: Output<String>? = null

    private var layers: Output<List<H264LayerArgs>>? = null

    private var odataType: Output<String>? = null

    private var rateControlMode: Output<Either<String, H264RateControlMode>>? = null

    private var sceneChangeDetection: Output<Boolean>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    private var syncMode: Output<Either<String, VideoSyncMode>>? = null

    /**
     * @param value Tells the encoder how to choose its encoding settings. The default value is Balanced.
     */
    @JvmName("ongjjotcenpfowtj")
    public suspend fun complexity(`value`: Output<Either<String, H264Complexity>>) {
        this.complexity = value
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("lrsgdeqjudiumvdj")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("vkrmacqjjeoamfur")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("lwukqhelwwedkbrs")
    public suspend fun layers(`value`: Output<List<H264LayerArgs>>) {
        this.layers = value
    }

    @JvmName("bmtvlvonvqoenoqu")
    public suspend fun layers(vararg values: Output<H264LayerArgs>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("cebgprfdbojdycfh")
    public suspend fun layers(values: List<Output<H264LayerArgs>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.H264Video'.
     */
    @JvmName("kbvykqxujjeydabx")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The video rate control mode
     */
    @JvmName("qdqsawhjffpigsrd")
    public suspend fun rateControlMode(`value`: Output<Either<String, H264RateControlMode>>) {
        this.rateControlMode = value
    }

    /**
     * @param value Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
     */
    @JvmName("bqawmeuliryyjivi")
    public suspend fun sceneChangeDetection(`value`: Output<Boolean>) {
        this.sceneChangeDetection = value
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("qrffjsbqtyvabbhm")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("ounojshqjllfueyq")
    public suspend fun syncMode(`value`: Output<Either<String, VideoSyncMode>>) {
        this.syncMode = value
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings. The default value is Balanced.
     */
    @JvmName("myyynpdnlgobuxba")
    public suspend fun complexity(`value`: Either<String, H264Complexity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings. The default value is Balanced.
     */
    @JvmName("bktotkxbtdcrfklh")
    public fun complexity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, H264Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value Tells the encoder how to choose its encoding settings. The default value is Balanced.
     */
    @JvmName("tedpccsygsoiwiyx")
    public fun complexity(`value`: H264Complexity) {
        val toBeMapped = Either.ofRight<String, H264Complexity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.complexity = mapped
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("nqrlbknwlresbeon")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("apifwffvghulamgv")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("johilhhvtengfwjw")
    public suspend fun layers(`value`: List<H264LayerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("maxsopgpjmgexatf")
    public suspend fun layers(argument: List<suspend H264LayerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { H264LayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("aeneildwfhjknmnf")
    public suspend fun layers(vararg argument: suspend H264LayerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { H264LayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("kuxdyuykwnbfrvkt")
    public suspend fun layers(argument: suspend H264LayerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(H264LayerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param values The collection of output H.264 layers to be produced by the encoder.
     */
    @JvmName("ofkbvesxwdjmdhgu")
    public suspend fun layers(vararg values: H264LayerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.H264Video'.
     */
    @JvmName("nrslximwkrqvgjjt")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The video rate control mode
     */
    @JvmName("dafvtpbnhpweyabv")
    public suspend fun rateControlMode(`value`: Either<String, H264RateControlMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value The video rate control mode
     */
    @JvmName("txgihluyqplgyrct")
    public fun rateControlMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, H264RateControlMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value The video rate control mode
     */
    @JvmName("atoxfsociwtstywd")
    public fun rateControlMode(`value`: H264RateControlMode) {
        val toBeMapped = Either.ofRight<String, H264RateControlMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
     */
    @JvmName("adceycrnixjbexwp")
    public suspend fun sceneChangeDetection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sceneChangeDetection = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("abpcokyghwihiurp")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("uxhxsgaeudfroaxu")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("skkxsnwaamqxutpl")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("exmhlnwetphuxxnh")
    public suspend fun syncMode(`value`: Either<String, VideoSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("cyeeaqwmfvpasfnl")
    public fun syncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("gxsslwjjkewwbjnu")
    public fun syncMode(`value`: VideoSyncMode) {
        val toBeMapped = Either.ofRight<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    internal fun build(): H264VideoArgs = H264VideoArgs(
        complexity = complexity,
        keyFrameInterval = keyFrameInterval,
        label = label,
        layers = layers,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        rateControlMode = rateControlMode,
        sceneChangeDetection = sceneChangeDetection,
        stretchMode = stretchMode,
        syncMode = syncMode,
    )
}
