@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.JpgImageArgs.builder
import com.pulumi.azurenative.media.kotlin.enums.StretchMode
import com.pulumi.azurenative.media.kotlin.enums.VideoSyncMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the properties for producing a series of JPEG images from the input video.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property layers A collection of output JPEG image layers to be produced by the encoder.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JpgImage'.
 * @property range The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
 * @property spriteColumn Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
 * @property start The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
 * @property step The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class JpgImageArgs(
    public val keyFrameInterval: Output<String>? = null,
    public val label: Output<String>? = null,
    public val layers: Output<List<JpgLayerArgs>>? = null,
    public val odataType: Output<String>,
    public val range: Output<String>? = null,
    public val spriteColumn: Output<Int>? = null,
    public val start: Output<String>,
    public val step: Output<String>? = null,
    public val stretchMode: Output<Either<String, StretchMode>>? = null,
    public val syncMode: Output<Either<String, VideoSyncMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.JpgImageArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.JpgImageArgs =
        com.pulumi.azurenative.media.inputs.JpgImageArgs.builder()
            .keyFrameInterval(keyFrameInterval?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .layers(layers?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .odataType(odataType.applyValue({ args0 -> args0 }))
            .range(range?.applyValue({ args0 -> args0 }))
            .spriteColumn(spriteColumn?.applyValue({ args0 -> args0 }))
            .start(start.applyValue({ args0 -> args0 }))
            .step(step?.applyValue({ args0 -> args0 }))
            .stretchMode(
                stretchMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncMode(
                syncMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [JpgImageArgs].
 */
@PulumiTagMarker
public class JpgImageArgsBuilder internal constructor() {
    private var keyFrameInterval: Output<String>? = null

    private var label: Output<String>? = null

    private var layers: Output<List<JpgLayerArgs>>? = null

    private var odataType: Output<String>? = null

    private var range: Output<String>? = null

    private var spriteColumn: Output<Int>? = null

    private var start: Output<String>? = null

    private var step: Output<String>? = null

    private var stretchMode: Output<Either<String, StretchMode>>? = null

    private var syncMode: Output<Either<String, VideoSyncMode>>? = null

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("inadfkofyfiaowtq")
    public suspend fun keyFrameInterval(`value`: Output<String>) {
        this.keyFrameInterval = value
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("fwwewticlrbgiuhq")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("ojghmbvnfpdwnphb")
    public suspend fun layers(`value`: Output<List<JpgLayerArgs>>) {
        this.layers = value
    }

    @JvmName("pxwnunvdjklwpslm")
    public suspend fun layers(vararg values: Output<JpgLayerArgs>) {
        this.layers = Output.all(values.asList())
    }

    /**
     * @param values A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("wkooayqwhuynvbqh")
    public suspend fun layers(values: List<Output<JpgLayerArgs>>) {
        this.layers = Output.all(values)
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JpgImage'.
     */
    @JvmName("kgjftpwljkkpbcdk")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
     */
    @JvmName("lubqvskjkpvhwamm")
    public suspend fun range(`value`: Output<String>) {
        this.range = value
    }

    /**
     * @param value Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
     */
    @JvmName("lpyemkhwbdtklnot")
    public suspend fun spriteColumn(`value`: Output<Int>) {
        this.spriteColumn = value
    }

    /**
     * @param value The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
     */
    @JvmName("pxheefrwxlddffum")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
     */
    @JvmName("hpxoiybtdyarojfl")
    public suspend fun step(`value`: Output<String>) {
        this.step = value
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("eannjdpwyucsvrpi")
    public suspend fun stretchMode(`value`: Output<Either<String, StretchMode>>) {
        this.stretchMode = value
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("wppfeljsehrdvkmn")
    public suspend fun syncMode(`value`: Output<Either<String, VideoSyncMode>>) {
        this.syncMode = value
    }

    /**
     * @param value The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
     */
    @JvmName("omagsebqinvnscwu")
    public suspend fun keyFrameInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFrameInterval = mapped
    }

    /**
     * @param value An optional label for the codec. The label can be used to control muxing behavior.
     */
    @JvmName("hlgcnihavduepuyc")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("wpgvaeygtwntcsre")
    public suspend fun layers(`value`: List<JpgLayerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param argument A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("hdeffvjnjmwkvorg")
    public suspend fun layers(argument: List<suspend JpgLayerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { JpgLayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("ldyyoteqjilkokxp")
    public suspend fun layers(vararg argument: suspend JpgLayerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { JpgLayerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param argument A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("qckpoctqeyeljjns")
    public suspend fun layers(argument: suspend JpgLayerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JpgLayerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.layers = mapped
    }

    /**
     * @param values A collection of output JPEG image layers to be produced by the encoder.
     */
    @JvmName("pfwqcajoacwugjwk")
    public suspend fun layers(vararg values: JpgLayerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layers = mapped
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.JpgImage'.
     */
    @JvmName("hxaoagqmjvvytqbx")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    /**
     * @param value The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
     */
    @JvmName("qunkgbgfpuvsjclm")
    public suspend fun range(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.range = mapped
    }

    /**
     * @param value Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
     */
    @JvmName("sndeviojhctejbam")
    public suspend fun spriteColumn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spriteColumn = mapped
    }

    /**
     * @param value The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
     */
    @JvmName("mnpeytlgjgjoilrq")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.start = mapped
    }

    /**
     * @param value The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
     */
    @JvmName("tqnpmtxvxdhnacjs")
    public suspend fun step(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.step = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("jkeqhixorkhqsfex")
    public suspend fun stretchMode(`value`: Either<String, StretchMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("elynyixvagrhigpq")
    public fun stretchMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
     */
    @JvmName("hanjuxrcbmiiwyxn")
    public fun stretchMode(`value`: StretchMode) {
        val toBeMapped = Either.ofRight<String, StretchMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stretchMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("cjyjtrkywtwdngxs")
    public suspend fun syncMode(`value`: Either<String, VideoSyncMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("ekhodvhhuyopgrmu")
    public fun syncMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    /**
     * @param value The Video Sync Mode
     */
    @JvmName("sxdhxlmnwycstbns")
    public fun syncMode(`value`: VideoSyncMode) {
        val toBeMapped = Either.ofRight<String, VideoSyncMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncMode = mapped
    }

    internal fun build(): JpgImageArgs = JpgImageArgs(
        keyFrameInterval = keyFrameInterval,
        label = label,
        layers = layers,
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
        range = range,
        spriteColumn = spriteColumn,
        start = start ?: throw PulumiNullFieldException("start"),
        step = step,
        stretchMode = stretchMode,
        syncMode = syncMode,
    )
}
