@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.JpgLayerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings to produce a JPEG image from the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property quality The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class JpgLayerArgs(
    public val height: Output<String>? = null,
    public val label: Output<String>? = null,
    public val quality: Output<Int>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.JpgLayerArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.JpgLayerArgs =
        com.pulumi.azurenative.media.inputs.JpgLayerArgs.builder()
            .height(height?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .quality(quality?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JpgLayerArgs].
 */
@PulumiTagMarker
public class JpgLayerArgsBuilder internal constructor() {
    private var height: Output<String>? = null

    private var label: Output<String>? = null

    private var quality: Output<Int>? = null

    private var width: Output<String>? = null

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("wqhvfrwoalbjmpvj")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("thxpekoidaqwhtqs")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
     */
    @JvmName("iplkpgvnuglehvwi")
    public suspend fun quality(`value`: Output<Int>) {
        this.quality = value
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("jryxinfviesugkhc")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("xyvonclkaxeymwuh")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("nrxdyhaxhbhxwovf")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
     */
    @JvmName("jqobgptxoguphpkq")
    public suspend fun quality(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quality = mapped
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("cwtmolcspflkbvfa")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): JpgLayerArgs = JpgLayerArgs(
        height = height,
        label = label,
        quality = quality,
        width = width,
    )
}
