@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventOutputTranscriptionTrackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
 * @property trackName The output track name. This property is reserved for future use, any value set on this property will be ignored.
 */
public data class LiveEventOutputTranscriptionTrackArgs(
    public val trackName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventOutputTranscriptionTrackArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventOutputTranscriptionTrackArgs =
        com.pulumi.azurenative.media.inputs.LiveEventOutputTranscriptionTrackArgs.builder()
            .trackName(trackName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventOutputTranscriptionTrackArgs].
 */
@PulumiTagMarker
public class LiveEventOutputTranscriptionTrackArgsBuilder internal constructor() {
    private var trackName: Output<String>? = null

    /**
     * @param value The output track name. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("rccpiixoxrurtiwu")
    public suspend fun trackName(`value`: Output<String>) {
        this.trackName = value
    }

    /**
     * @param value The output track name. This property is reserved for future use, any value set on this property will be ignored.
     */
    @JvmName("lrpseoupsjngmria")
    public suspend fun trackName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackName = mapped
    }

    internal fun build(): LiveEventOutputTranscriptionTrackArgs =
        LiveEventOutputTranscriptionTrackArgs(
            trackName = trackName ?: throw PulumiNullFieldException("trackName"),
        )
}
