@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventPreviewAccessControlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The IP access control for the live event preview endpoint.
 * @property ip The IP access control properties.
 */
public data class LiveEventPreviewAccessControlArgs(
    public val ip: Output<IPAccessControlArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventPreviewAccessControlArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventPreviewAccessControlArgs =
        com.pulumi.azurenative.media.inputs.LiveEventPreviewAccessControlArgs.builder()
            .ip(ip?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LiveEventPreviewAccessControlArgs].
 */
@PulumiTagMarker
public class LiveEventPreviewAccessControlArgsBuilder internal constructor() {
    private var ip: Output<IPAccessControlArgs>? = null

    /**
     * @param value The IP access control properties.
     */
    @JvmName("uicavexijdwpbdfe")
    public suspend fun ip(`value`: Output<IPAccessControlArgs>) {
        this.ip = value
    }

    /**
     * @param value The IP access control properties.
     */
    @JvmName("lygcxdtryfcmdkxv")
    public suspend fun ip(`value`: IPAccessControlArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param argument The IP access control properties.
     */
    @JvmName("tnjsxwahtptmtbfv")
    public suspend fun ip(argument: suspend IPAccessControlArgsBuilder.() -> Unit) {
        val toBeMapped = IPAccessControlArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ip = mapped
    }

    internal fun build(): LiveEventPreviewAccessControlArgs = LiveEventPreviewAccessControlArgs(
        ip = ip,
    )
}
