@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.LiveEventTimedMetadataEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The live event metadata insertion endpoint.
 * @property url The metadata endpoint URL.
 */
public data class LiveEventTimedMetadataEndpointArgs(
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.LiveEventTimedMetadataEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.LiveEventTimedMetadataEndpointArgs =
        com.pulumi.azurenative.media.inputs.LiveEventTimedMetadataEndpointArgs.builder()
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LiveEventTimedMetadataEndpointArgs].
 */
@PulumiTagMarker
public class LiveEventTimedMetadataEndpointArgsBuilder internal constructor() {
    private var url: Output<String>? = null

    /**
     * @param value The metadata endpoint URL.
     */
    @JvmName("hdcmrvbvnkwjaswj")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The metadata endpoint URL.
     */
    @JvmName("minlcaxhccwedjrc")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): LiveEventTimedMetadataEndpointArgs = LiveEventTimedMetadataEndpointArgs(
        url = url,
    )
}
