@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.PngLayerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings to produce a PNG image from the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class PngLayerArgs(
    public val height: Output<String>? = null,
    public val label: Output<String>? = null,
    public val width: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.PngLayerArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.PngLayerArgs =
        com.pulumi.azurenative.media.inputs.PngLayerArgs.builder()
            .height(height?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PngLayerArgs].
 */
@PulumiTagMarker
public class PngLayerArgsBuilder internal constructor() {
    private var height: Output<String>? = null

    private var label: Output<String>? = null

    private var width: Output<String>? = null

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("tlqkotdqqcgtqixd")
    public suspend fun height(`value`: Output<String>) {
        this.height = value
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("bxvscvdtpmuebqoq")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("xonivlhgmfmjecou")
    public suspend fun width(`value`: Output<String>) {
        this.width = value
    }

    /**
     * @param value The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
     */
    @JvmName("afnjauylhiuxmwmg")
    public suspend fun height(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
     */
    @JvmName("slgeofkegkoaehcx")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
     */
    @JvmName("tgqwvqykjwjlsrbf")
    public suspend fun width(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): PngLayerArgs = PngLayerArgs(
        height = height,
        label = label,
        width = width,
    )
}
