@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class to specify properties of all content keys in Streaming Policy
 * @property defaultKey Default content key for an encryption scheme
 * @property keyToTrackMappings Representing tracks needs separate content key
 */
public data class StreamingPolicyContentKeysArgs(
    public val defaultKey: Output<DefaultKeyArgs>? = null,
    public val keyToTrackMappings: Output<List<StreamingPolicyContentKeyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs =
        com.pulumi.azurenative.media.inputs.StreamingPolicyContentKeysArgs.builder()
            .defaultKey(defaultKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyToTrackMappings(
                keyToTrackMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [StreamingPolicyContentKeysArgs].
 */
@PulumiTagMarker
public class StreamingPolicyContentKeysArgsBuilder internal constructor() {
    private var defaultKey: Output<DefaultKeyArgs>? = null

    private var keyToTrackMappings: Output<List<StreamingPolicyContentKeyArgs>>? = null

    /**
     * @param value Default content key for an encryption scheme
     */
    @JvmName("xquwtmbttfxncfmw")
    public suspend fun defaultKey(`value`: Output<DefaultKeyArgs>) {
        this.defaultKey = value
    }

    /**
     * @param value Representing tracks needs separate content key
     */
    @JvmName("rnlfletfywmqyhjp")
    public suspend fun keyToTrackMappings(`value`: Output<List<StreamingPolicyContentKeyArgs>>) {
        this.keyToTrackMappings = value
    }

    @JvmName("sdslmbtjxmyfmkxd")
    public suspend fun keyToTrackMappings(vararg values: Output<StreamingPolicyContentKeyArgs>) {
        this.keyToTrackMappings = Output.all(values.asList())
    }

    /**
     * @param values Representing tracks needs separate content key
     */
    @JvmName("npsjbbignaeierky")
    public suspend fun keyToTrackMappings(values: List<Output<StreamingPolicyContentKeyArgs>>) {
        this.keyToTrackMappings = Output.all(values)
    }

    /**
     * @param value Default content key for an encryption scheme
     */
    @JvmName("fjrvlrpsacylydcc")
    public suspend fun defaultKey(`value`: DefaultKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultKey = mapped
    }

    /**
     * @param argument Default content key for an encryption scheme
     */
    @JvmName("wtnyuwlsrcnllgqr")
    public suspend fun defaultKey(argument: suspend DefaultKeyArgsBuilder.() -> Unit) {
        val toBeMapped = DefaultKeyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultKey = mapped
    }

    /**
     * @param value Representing tracks needs separate content key
     */
    @JvmName("iblbybxiqwsjldvv")
    public suspend fun keyToTrackMappings(`value`: List<StreamingPolicyContentKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyToTrackMappings = mapped
    }

    /**
     * @param argument Representing tracks needs separate content key
     */
    @JvmName("ahklkqgouxotbiqp")
    public suspend
    fun keyToTrackMappings(argument: List<suspend StreamingPolicyContentKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StreamingPolicyContentKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyToTrackMappings = mapped
    }

    /**
     * @param argument Representing tracks needs separate content key
     */
    @JvmName("poxnhivpgiojlasg")
    public suspend fun keyToTrackMappings(
        vararg
        argument: suspend StreamingPolicyContentKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StreamingPolicyContentKeyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyToTrackMappings = mapped
    }

    /**
     * @param argument Representing tracks needs separate content key
     */
    @JvmName("cpskvlfrxovtewfk")
    public suspend
    fun keyToTrackMappings(argument: suspend StreamingPolicyContentKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StreamingPolicyContentKeyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.keyToTrackMappings = mapped
    }

    /**
     * @param values Representing tracks needs separate content key
     */
    @JvmName("sbbqhmyfhpaoxnkn")
    public suspend fun keyToTrackMappings(vararg values: StreamingPolicyContentKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyToTrackMappings = mapped
    }

    internal fun build(): StreamingPolicyContentKeysArgs = StreamingPolicyContentKeysArgs(
        defaultKey = defaultKey,
        keyToTrackMappings = keyToTrackMappings,
    )
}
