@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class to specify configurations of PlayReady in Streaming Policy
 * @property customLicenseAcquisitionUrlTemplate Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 * @property playReadyCustomAttributes Custom attributes for PlayReady
 */
public data class StreamingPolicyPlayReadyConfigurationArgs(
    public val customLicenseAcquisitionUrlTemplate: Output<String>? = null,
    public val playReadyCustomAttributes: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs =
        com.pulumi.azurenative.media.inputs.StreamingPolicyPlayReadyConfigurationArgs.builder()
            .customLicenseAcquisitionUrlTemplate(
                customLicenseAcquisitionUrlTemplate?.applyValue({ args0 ->
                    args0
                }),
            )
            .playReadyCustomAttributes(playReadyCustomAttributes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamingPolicyPlayReadyConfigurationArgs].
 */
@PulumiTagMarker
public class StreamingPolicyPlayReadyConfigurationArgsBuilder internal constructor() {
    private var customLicenseAcquisitionUrlTemplate: Output<String>? = null

    private var playReadyCustomAttributes: Output<String>? = null

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("olhxiwvsifrlnjlu")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: Output<String>) {
        this.customLicenseAcquisitionUrlTemplate = value
    }

    /**
     * @param value Custom attributes for PlayReady
     */
    @JvmName("defdmnxbmviewutt")
    public suspend fun playReadyCustomAttributes(`value`: Output<String>) {
        this.playReadyCustomAttributes = value
    }

    /**
     * @param value Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
     */
    @JvmName("niulajkcuaaicqmm")
    public suspend fun customLicenseAcquisitionUrlTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLicenseAcquisitionUrlTemplate = mapped
    }

    /**
     * @param value Custom attributes for PlayReady
     */
    @JvmName("xttcfrwkknnvmpdb")
    public suspend fun playReadyCustomAttributes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playReadyCustomAttributes = mapped
    }

    internal fun build(): StreamingPolicyPlayReadyConfigurationArgs =
        StreamingPolicyPlayReadyConfigurationArgs(
            customLicenseAcquisitionUrlTemplate = customLicenseAcquisitionUrlTemplate,
            playReadyCustomAttributes = playReadyCustomAttributes,
        )
}
