@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.TrackSelectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Class to select a track
 * @property trackSelections TrackSelections is a track property condition list which can specify track(s)
 */
public data class TrackSelectionArgs(
    public val trackSelections: Output<List<TrackPropertyConditionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.TrackSelectionArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.TrackSelectionArgs =
        com.pulumi.azurenative.media.inputs.TrackSelectionArgs.builder()
            .trackSelections(
                trackSelections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [TrackSelectionArgs].
 */
@PulumiTagMarker
public class TrackSelectionArgsBuilder internal constructor() {
    private var trackSelections: Output<List<TrackPropertyConditionArgs>>? = null

    /**
     * @param value TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("tupporiltvlmqpmr")
    public suspend fun trackSelections(`value`: Output<List<TrackPropertyConditionArgs>>) {
        this.trackSelections = value
    }

    @JvmName("dkexeffotslsgaas")
    public suspend fun trackSelections(vararg values: Output<TrackPropertyConditionArgs>) {
        this.trackSelections = Output.all(values.asList())
    }

    /**
     * @param values TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("itpckrhyylnhfyur")
    public suspend fun trackSelections(values: List<Output<TrackPropertyConditionArgs>>) {
        this.trackSelections = Output.all(values)
    }

    /**
     * @param value TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("kihvjotfvawclkau")
    public suspend fun trackSelections(`value`: List<TrackPropertyConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackSelections = mapped
    }

    /**
     * @param argument TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("fxhgacmkrsffklog")
    public suspend
    fun trackSelections(argument: List<suspend TrackPropertyConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TrackPropertyConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param argument TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("foqyracnipxmuqie")
    public suspend fun trackSelections(
        vararg
        argument: suspend TrackPropertyConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TrackPropertyConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param argument TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("ybxeelcswkluhlsg")
    public suspend
    fun trackSelections(argument: suspend TrackPropertyConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TrackPropertyConditionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.trackSelections = mapped
    }

    /**
     * @param values TrackSelections is a track property condition list which can specify track(s)
     */
    @JvmName("rqgtsfjawyosdsfp")
    public suspend fun trackSelections(vararg values: TrackPropertyConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackSelections = mapped
    }

    internal fun build(): TrackSelectionArgs = TrackSelectionArgs(
        trackSelections = trackSelections,
    )
}
