@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.inputs

import com.pulumi.azurenative.media.inputs.VideoTrackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a video track in the asset.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoTrack'.
 */
public data class VideoTrackArgs(
    public val odataType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.media.inputs.VideoTrackArgs> {
    override fun toJava(): com.pulumi.azurenative.media.inputs.VideoTrackArgs =
        com.pulumi.azurenative.media.inputs.VideoTrackArgs.builder()
            .odataType(odataType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VideoTrackArgs].
 */
@PulumiTagMarker
public class VideoTrackArgsBuilder internal constructor() {
    private var odataType: Output<String>? = null

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.VideoTrack'.
     */
    @JvmName("dmfmqxgupyocnadp")
    public suspend fun odataType(`value`: Output<String>) {
        this.odataType = value
    }

    /**
     * @param value The discriminator for derived types.
     * Expected value is '#Microsoft.Media.VideoTrack'.
     */
    @JvmName("fltboerhvbqirkmv")
    public suspend fun odataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.odataType = mapped
    }

    internal fun build(): VideoTrackArgs = VideoTrackArgs(
        odataType = odataType ?: throw PulumiNullFieldException("odataType"),
    )
}
