@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Represents an audio track in the asset.
 * @property bitRate The stream bit rate for the audio track.
 * @property dashSettings The DASH specific setting for the audio track.
 * @property displayName The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
 * @property fileName The file name to the source file. This file is located in the storage container of the asset.
 * @property hlsSettings The HLS specific setting for the audio track.
 * @property languageCode The RFC5646 language code for the audio track.
 * @property mpeg4TrackId The MPEG-4 audio track ID for the audio track.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.AudioTrack'.
 */
public data class AudioTrackResponse(
    public val bitRate: Int,
    public val dashSettings: DashSettingsResponse? = null,
    public val displayName: String? = null,
    public val fileName: String? = null,
    public val hlsSettings: HlsSettingsResponse? = null,
    public val languageCode: String? = null,
    public val mpeg4TrackId: Int? = null,
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.AudioTrackResponse):
            AudioTrackResponse = AudioTrackResponse(
            bitRate = javaType.bitRate(),
            dashSettings = javaType.dashSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.DashSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            hlsSettings = javaType.hlsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.HlsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            languageCode = javaType.languageCode().map({ args0 -> args0 }).orElse(null),
            mpeg4TrackId = javaType.mpeg4TrackId().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
