@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a built-in preset for encoding the input video with the Standard Encoder.
 * @property configurations Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.BuiltInStandardEncoderPreset'.
 * @property presetName The built-in preset to be used for encoding videos.
 */
public data class BuiltInStandardEncoderPresetResponse(
    public val configurations: PresetConfigurationsResponse? = null,
    public val odataType: String,
    public val presetName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.BuiltInStandardEncoderPresetResponse):
            BuiltInStandardEncoderPresetResponse = BuiltInStandardEncoderPresetResponse(
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.PresetConfigurationsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            odataType = javaType.odataType(),
            presetName = javaType.presetName(),
        )
    }
}
