@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Class for envelope encryption scheme
 * @property clearKeyEncryptionConfiguration Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
 * @property clearTracks Representing which tracks should not be encrypted
 * @property contentKeys Representing default content key for each encryption scheme and separate content keys for specific tracks
 * @property drm Configuration of DRMs for CommonEncryptionCenc encryption scheme
 * @property enabledProtocols Representing supported protocols
 */
public data class CommonEncryptionCencResponse(
    public val clearKeyEncryptionConfiguration: ClearKeyEncryptionConfigurationResponse? = null,
    public val clearTracks: List<TrackSelectionResponse>? = null,
    public val contentKeys: StreamingPolicyContentKeysResponse? = null,
    public val drm: CencDrmConfigurationResponse? = null,
    public val enabledProtocols: EnabledProtocolsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.CommonEncryptionCencResponse):
            CommonEncryptionCencResponse = CommonEncryptionCencResponse(
            clearKeyEncryptionConfiguration = javaType.clearKeyEncryptionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ClearKeyEncryptionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clearTracks = javaType.clearTracks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.TrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
            contentKeys = javaType.contentKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyContentKeysResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            drm = javaType.drm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.CencDrmConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabledProtocols = javaType.enabledProtocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.EnabledProtocolsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
