@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Specifies a configuration for FairPlay licenses.
 * @property ask The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
 * @property fairPlayPfx The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
 * @property fairPlayPfxPassword The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration'.
 * @property offlineRentalConfiguration Offline rental policy
 * @property rentalAndLeaseKeyType The rental and lease key type.
 * @property rentalDuration The rental duration. Must be greater than or equal to 0.
 */
public data class ContentKeyPolicyFairPlayConfigurationResponse(
    public val ask: String,
    public val fairPlayPfx: String,
    public val fairPlayPfxPassword: String,
    public val odataType: String,
    public val offlineRentalConfiguration: ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse? =
        null,
    public val rentalAndLeaseKeyType: String,
    public val rentalDuration: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyFairPlayConfigurationResponse):
            ContentKeyPolicyFairPlayConfigurationResponse =
            ContentKeyPolicyFairPlayConfigurationResponse(
                ask = javaType.ask(),
                fairPlayPfx = javaType.fairPlayPfx(),
                fairPlayPfxPassword = javaType.fairPlayPfxPassword(),
                odataType = javaType.odataType(),
                offlineRentalConfiguration = javaType.offlineRentalConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyFairPlayOfflineRentalConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rentalAndLeaseKeyType = javaType.rentalAndLeaseKeyType(),
                rentalDuration = javaType.rentalDuration(),
            )
    }
}
