@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The PlayReady license
 * @property allowTestDevices A flag indicating whether test devices can use the license.
 * @property beginDate The begin date of license
 * @property contentKeyLocation The content key location.
 * @property contentType The PlayReady content type.
 * @property expirationDate The expiration date of license.
 * @property gracePeriod The grace period of license.
 * @property licenseType The license type.
 * @property playRight The license PlayRight
 * @property relativeBeginDate The relative begin date of license.
 * @property relativeExpirationDate The relative expiration date of license.
 * @property securityLevel The security level.
 */
public data class ContentKeyPolicyPlayReadyLicenseResponse(
    public val allowTestDevices: Boolean,
    public val beginDate: String? = null,
    public val contentKeyLocation:
    Either<ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse, ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse>,
    public val contentType: String,
    public val expirationDate: String? = null,
    public val gracePeriod: String? = null,
    public val licenseType: String,
    public val playRight: ContentKeyPolicyPlayReadyPlayRightResponse? = null,
    public val relativeBeginDate: String? = null,
    public val relativeExpirationDate: String? = null,
    public val securityLevel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyPlayReadyLicenseResponse):
            ContentKeyPolicyPlayReadyLicenseResponse = ContentKeyPolicyPlayReadyLicenseResponse(
            allowTestDevices = javaType.allowTestDevices(),
            beginDate = javaType.beginDate().map({ args0 -> args0 }).orElse(null),
            contentKeyLocation = javaType.contentKeyLocation().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeaderResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifierResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            contentType = javaType.contentType(),
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            gracePeriod = javaType.gracePeriod().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType(),
            playRight = javaType.playRight().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyPlayReadyPlayRightResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            relativeBeginDate = javaType.relativeBeginDate().map({ args0 -> args0 }).orElse(null),
            relativeExpirationDate = javaType.relativeExpirationDate().map({ args0 -> args0 }).orElse(null),
            securityLevel = javaType.securityLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
