@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies a configuration for Widevine licenses.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyWidevineConfiguration'.
 * @property widevineTemplate The Widevine template.
 */
public data class ContentKeyPolicyWidevineConfigurationResponse(
    public val odataType: String,
    public val widevineTemplate: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyWidevineConfigurationResponse):
            ContentKeyPolicyWidevineConfigurationResponse =
            ContentKeyPolicyWidevineConfigurationResponse(
                odataType = javaType.odataType(),
                widevineTemplate = javaType.widevineTemplate(),
            )
    }
}
