@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specifies a certificate for token validation.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey'.
 * @property rawBody The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
 */
public data class ContentKeyPolicyX509CertificateTokenKeyResponse(
    public val odataType: String,
    public val rawBody: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.ContentKeyPolicyX509CertificateTokenKeyResponse):
            ContentKeyPolicyX509CertificateTokenKeyResponse =
            ContentKeyPolicyX509CertificateTokenKeyResponse(
                odataType = javaType.odataType(),
                rawBody = javaType.rawBody(),
            )
    }
}
