@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class for EnvelopeEncryption encryption scheme
 * @property clearTracks Representing which tracks should not be encrypted
 * @property contentKeys Representing default content key for each encryption scheme and separate content keys for specific tracks
 * @property customKeyAcquisitionUrlTemplate Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
 * @property enabledProtocols Representing supported protocols
 */
public data class EnvelopeEncryptionResponse(
    public val clearTracks: List<TrackSelectionResponse>? = null,
    public val contentKeys: StreamingPolicyContentKeysResponse? = null,
    public val customKeyAcquisitionUrlTemplate: String? = null,
    public val enabledProtocols: EnabledProtocolsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.EnvelopeEncryptionResponse):
            EnvelopeEncryptionResponse = EnvelopeEncryptionResponse(
            clearTracks = javaType.clearTracks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.TrackSelectionResponse.Companion.toKotlin(args0)
                })
            }),
            contentKeys = javaType.contentKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingPolicyContentKeysResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customKeyAcquisitionUrlTemplate = javaType.customKeyAcquisitionUrlTemplate().map({ args0 ->
                args0
            }).orElse(null),
            enabledProtocols = javaType.enabledProtocols().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.EnabledProtocolsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
