@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A Content Key Policy resource.
 * @property created The creation date of the Policy
 * @property description A description for the Policy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModified The last modified date of the Policy
 * @property name The name of the resource
 * @property options The Key Policy options.
 * @property policyId The legacy Policy ID.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContentKeyPolicyResult(
    public val created: String,
    public val description: String? = null,
    public val id: String,
    public val lastModified: String,
    public val name: String,
    public val options: List<ContentKeyPolicyOptionResponse>,
    public val policyId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetContentKeyPolicyResult):
            GetContentKeyPolicyResult = GetContentKeyPolicyResult(
            created = javaType.created(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            name = javaType.name(),
            options = javaType.options().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ContentKeyPolicyOptionResponse.Companion.toKotlin(args0)
                })
            }),
            policyId = javaType.policyId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
