@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The streaming endpoint.
 * @property accessControl The access control definition of the streaming endpoint.
 * @property availabilitySetName This feature is deprecated, do not set a value for this property.
 * @property cdnEnabled The CDN enabled flag.
 * @property cdnProfile The CDN profile name.
 * @property cdnProvider The CDN provider name.
 * @property created The exact time the streaming endpoint was created.
 * @property crossSiteAccessPolicies The streaming endpoint access policies.
 * @property customHostNames The custom host names of the streaming endpoint
 * @property description The streaming endpoint description.
 * @property freeTrialEndTime The free trial expiration time.
 * @property hostName The streaming endpoint host name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModified The exact time the streaming endpoint was last modified.
 * @property location The geo-location where the resource lives
 * @property maxCacheAge Max cache age
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the streaming endpoint.
 * @property resourceState The resource state of the streaming endpoint.
 * @property scaleUnits The number of scale units. Use the Scale operation to adjust this value.
 * @property sku The streaming endpoint sku.
 * @property systemData The system metadata relating to this resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStreamingEndpointResult(
    public val accessControl: StreamingEndpointAccessControlResponse? = null,
    public val availabilitySetName: String? = null,
    public val cdnEnabled: Boolean? = null,
    public val cdnProfile: String? = null,
    public val cdnProvider: String? = null,
    public val created: String,
    public val crossSiteAccessPolicies: CrossSiteAccessPoliciesResponse? = null,
    public val customHostNames: List<String>? = null,
    public val description: String? = null,
    public val freeTrialEndTime: String,
    public val hostName: String,
    public val id: String,
    public val lastModified: String,
    public val location: String,
    public val maxCacheAge: Double? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceState: String,
    public val scaleUnits: Int,
    public val sku: ArmStreamingEndpointCurrentSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.GetStreamingEndpointResult):
            GetStreamingEndpointResult = GetStreamingEndpointResult(
            accessControl = javaType.accessControl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.StreamingEndpointAccessControlResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availabilitySetName = javaType.availabilitySetName().map({ args0 -> args0 }).orElse(null),
            cdnEnabled = javaType.cdnEnabled().map({ args0 -> args0 }).orElse(null),
            cdnProfile = javaType.cdnProfile().map({ args0 -> args0 }).orElse(null),
            cdnProvider = javaType.cdnProvider().map({ args0 -> args0 }).orElse(null),
            created = javaType.created(),
            crossSiteAccessPolicies = javaType.crossSiteAccessPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.CrossSiteAccessPoliciesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customHostNames = javaType.customHostNames().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            freeTrialEndTime = javaType.freeTrialEndTime(),
            hostName = javaType.hostName(),
            id = javaType.id(),
            lastModified = javaType.lastModified(),
            location = javaType.location(),
            maxCacheAge = javaType.maxCacheAge().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            scaleUnits = javaType.scaleUnits(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.ArmStreamingEndpointCurrentSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.media.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
