@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.
 * @property adaptiveBFrame Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
 * @property bFrames The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
 * @property bitrate The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
 * @property bufferWindow The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0&#46;1-100] seconds. The default is 5 seconds (for example, PT5S).
 * @property crf The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51, where lower values would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point quality degradation will be noticed. Default value is 28.
 * @property frameRate The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
 * @property height The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
 * @property label The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
 * @property level We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
 * @property maxBitrate The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
 * @property profile We currently support Main. Default is Auto.
 * @property referenceFrames The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
 * @property slices The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
 * @property width The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
 */
public data class H265LayerResponse(
    public val adaptiveBFrame: Boolean? = null,
    public val bFrames: Int? = null,
    public val bitrate: Int,
    public val bufferWindow: String? = null,
    public val crf: Double? = null,
    public val frameRate: String? = null,
    public val height: String? = null,
    public val label: String? = null,
    public val level: String? = null,
    public val maxBitrate: Int? = null,
    public val profile: String? = null,
    public val referenceFrames: Int? = null,
    public val slices: Int? = null,
    public val width: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.H265LayerResponse):
            H265LayerResponse = H265LayerResponse(
            adaptiveBFrame = javaType.adaptiveBFrame().map({ args0 -> args0 }).orElse(null),
            bFrames = javaType.bFrames().map({ args0 -> args0 }).orElse(null),
            bitrate = javaType.bitrate(),
            bufferWindow = javaType.bufferWindow().map({ args0 -> args0 }).orElse(null),
            crf = javaType.crf().map({ args0 -> args0 }).orElse(null),
            frameRate = javaType.frameRate().map({ args0 -> args0 }).orElse(null),
            height = javaType.height().map({ args0 -> args0 }).orElse(null),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            maxBitrate = javaType.maxBitrate().map({ args0 -> args0 }).orElse(null),
            profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
            referenceFrames = javaType.referenceFrames().map({ args0 -> args0 }).orElse(null),
            slices = javaType.slices().map({ args0 -> args0 }).orElse(null),
            width = javaType.width().map({ args0 -> args0 }).orElse(null),
        )
    }
}
