@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents an Asset for input into a Job.
 * @property assetName The name of the input Asset.
 * @property end Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
 * @property files List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service responses to prevent sensitive data exposure.
 * @property inputDefinitions Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
 * @property label A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.JobInputAsset'.
 * @property start Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
 */
public data class JobInputAssetResponse(
    public val assetName: String,
    public val end: Either<AbsoluteClipTimeResponse, UtcClipTimeResponse>? = null,
    public val files: List<String>? = null,
    public val inputDefinitions: List<Any>? = null,
    public val label: String? = null,
    public val odataType: String,
    public val start: Either<AbsoluteClipTimeResponse, UtcClipTimeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.JobInputAssetResponse):
            JobInputAssetResponse = JobInputAssetResponse(
            assetName = javaType.assetName(),
            end = javaType.end().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.AbsoluteClipTimeResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.UtcClipTimeResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            files = javaType.files().map({ args0 -> args0 }),
            inputDefinitions = javaType.inputDefinitions().map({ args0 -> args0 }),
            label = javaType.label().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
            start = javaType.start().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.AbsoluteClipTimeResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.media.kotlin.outputs.UtcClipTimeResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
        )
    }
}
