@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The live event status.
 * @property healthDescriptions List of strings justifying the health status.
 * @property healthStatus Health status of last 20 seconds.
 * @property ingestion Live event ingestion entry.
 * @property lastUpdatedTime Last updated UTC time of this status.
 * @property state Current state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
 * @property trackStatus Track entry list.
 */
public data class LiveEventStatusResponse(
    public val healthDescriptions: List<String>? = null,
    public val healthStatus: String? = null,
    public val ingestion: LiveEventIngestionResponse? = null,
    public val lastUpdatedTime: String? = null,
    public val state: String? = null,
    public val trackStatus: List<LiveEventTrackStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.LiveEventStatusResponse):
            LiveEventStatusResponse = LiveEventStatusResponse(
            healthDescriptions = javaType.healthDescriptions().map({ args0 -> args0 }),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            ingestion = javaType.ingestion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventIngestionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastUpdatedTime = javaType.lastUpdatedTime().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            trackStatus = javaType.trackStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.media.kotlin.outputs.LiveEventTrackStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
