@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An object of optional configuration settings for encoder.
 * @property complexity Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity as Speed for faster encoding but less compression efficiency.
 * @property interleaveOutput Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files.
 * @property keyFrameIntervalInSeconds The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
 * @property maxBitrateBps The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for contents with high complexity.
 * @property maxHeight The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the input is 4K.
 * @property maxLayers The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced to control the overall cost of the encoding job.
 * @property minBitrateBps The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low network bandwidth.
 * @property minHeight The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions like 180P.
 */
public data class PresetConfigurationsResponse(
    public val complexity: String? = null,
    public val interleaveOutput: String? = null,
    public val keyFrameIntervalInSeconds: Double? = null,
    public val maxBitrateBps: Int? = null,
    public val maxHeight: Int? = null,
    public val maxLayers: Int? = null,
    public val minBitrateBps: Int? = null,
    public val minHeight: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.PresetConfigurationsResponse):
            PresetConfigurationsResponse = PresetConfigurationsResponse(
            complexity = javaType.complexity().map({ args0 -> args0 }).orElse(null),
            interleaveOutput = javaType.interleaveOutput().map({ args0 -> args0 }).orElse(null),
            keyFrameIntervalInSeconds = javaType.keyFrameIntervalInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            maxBitrateBps = javaType.maxBitrateBps().map({ args0 -> args0 }).orElse(null),
            maxHeight = javaType.maxHeight().map({ args0 -> args0 }).orElse(null),
            maxLayers = javaType.maxLayers().map({ args0 -> args0 }).orElse(null),
            minBitrateBps = javaType.minBitrateBps().map({ args0 -> args0 }).orElse(null),
            minHeight = javaType.minHeight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
