@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Select video tracks from the input by specifying an attribute and an attribute filter.
 * @property attribute The TrackAttribute to filter the tracks by.
 * @property filter The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
 * @property filterValue The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.SelectVideoTrackByAttribute'.
 */
public data class SelectVideoTrackByAttributeResponse(
    public val attribute: String,
    public val filter: String,
    public val filterValue: String? = null,
    public val odataType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.SelectVideoTrackByAttributeResponse):
            SelectVideoTrackByAttributeResponse = SelectVideoTrackByAttributeResponse(
            attribute = javaType.attribute(),
            filter = javaType.filter(),
            filterValue = javaType.filterValue().map({ args0 -> args0 }).orElse(null),
            odataType = javaType.odataType(),
        )
    }
}
