@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the basic properties for encoding the input video.
 * @property keyFrameInterval The distance between two key frames. The value should be non-zero in the range [0&#46;5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
 * @property label An optional label for the codec. The label can be used to control muxing behavior.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.Video'.
 * @property stretchMode The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
 * @property syncMode The Video Sync Mode
 */
public data class VideoResponse(
    public val keyFrameInterval: String? = null,
    public val label: String? = null,
    public val odataType: String,
    public val stretchMode: String? = null,
    public val syncMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.VideoResponse): VideoResponse =
            VideoResponse(
                keyFrameInterval = javaType.keyFrameInterval().map({ args0 -> args0 }).orElse(null),
                label = javaType.label().map({ args0 -> args0 }).orElse(null),
                odataType = javaType.odataType(),
                stretchMode = javaType.stretchMode().map({ args0 -> args0 }).orElse(null),
                syncMode = javaType.syncMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
