@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.media.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a video track in the asset.
 * @property odataType The discriminator for derived types.
 * Expected value is '#Microsoft.Media.VideoTrack'.
 */
public data class VideoTrackResponse(
    public val odataType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.media.outputs.VideoTrackResponse):
            VideoTrackResponse = VideoTrackResponse(
            odataType = javaType.odataType(),
        )
    }
}
