@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Assessment].
 */
@PulumiTagMarker
public class AssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentArgs = AssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentArgsBuilder.() -> Unit) {
        val builder = AssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Assessment {
        val builtJavaResource = com.pulumi.azurenative.migrate.Assessment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Assessment(builtJavaResource)
    }
}

/**
 * An assessment created for a group in the Migration project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2017-11-11-preview, 2018-02-02.
 * ## Example Usage
 * ### Assessments_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessment = new AzureNative.Migrate.Assessment("assessment", new()
 *     {
 *         AssessmentName = "assessment_5_14_2019_16_48_47",
 *         ETag = "\"1e000c2c-0000-0d00-0000-5cdaa4190000\"",
 *         GroupName = "Group2",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.AssessmentPropertiesArgs
 *         {
 *             AzureDiskType = AzureNative.Migrate.AzureDiskType.StandardOrPremium,
 *             AzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Yes,
 *             AzureLocation = AzureNative.Migrate.AzureLocation.NorthEurope,
 *             AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *             AzurePricingTier = AzureNative.Migrate.AzurePricingTier.Standard,
 *             AzureStorageRedundancy = AzureNative.Migrate.AzureStorageRedundancy.LocallyRedundant,
 *             AzureVmFamilies = new[]
 *             {
 *                 AzureNative.Migrate.AzureVmFamily.Dv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.FSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Dv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.DSSeries,
 *                 AzureNative.Migrate.AzureVmFamily.DSv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.FsSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Dsv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.Ev3Series,
 *                 AzureNative.Migrate.AzureVmFamily.Esv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.DSeries,
 *                 AzureNative.Migrate.AzureVmFamily.MSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Fsv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.HSeries,
 *             },
 *             Currency = AzureNative.Migrate.Currency.USD,
 *             DiscountPercentage = 100,
 *             Percentile = AzureNative.Migrate.Percentile.Percentile95,
 *             ReservedInstance = AzureNative.Migrate.ReservedInstance.RI3Year,
 *             ScalingFactor = 1,
 *             SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *             Stage = AzureNative.Migrate.AssessmentStage.InProgress,
 *             TimeRange = AzureNative.Migrate.TimeRange.Day,
 *             VmUptime = new AzureNative.Migrate.Inputs.VmUptimeArgs
 *             {
 *                 DaysPerMonth = 31,
 *                 HoursPerDay = 24,
 *             },
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessment(ctx, "assessment", &migrate.AssessmentArgs{
 * 			AssessmentName: pulumi.String("assessment_5_14_2019_16_48_47"),
 * 			ETag:           pulumi.String("\"1e000c2c-0000-0d00-0000-5cdaa4190000\""),
 * 			GroupName:      pulumi.String("Group2"),
 * 			ProjectName:    pulumi.String("abgoyalWEselfhostb72bproject"),
 * 			Properties: &migrate.AssessmentPropertiesArgs{
 * 				AzureDiskType:          pulumi.String(migrate.AzureDiskTypeStandardOrPremium),
 * 				AzureHybridUseBenefit:  pulumi.String(migrate.AzureHybridUseBenefitYes),
 * 				AzureLocation:          pulumi.String(migrate.AzureLocationNorthEurope),
 * 				AzureOfferCode:         pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 				AzurePricingTier:       pulumi.String(migrate.AzurePricingTierStandard),
 * 				AzureStorageRedundancy: pulumi.String(migrate.AzureStorageRedundancyLocallyRedundant),
 * 				AzureVmFamilies: pulumi.StringArray{
 * 					pulumi.String(migrate.AzureVmFamilyDv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyFSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyDSSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDSv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyFsSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDsv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyEv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyEsv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyDSeries),
 * 					pulumi.String(migrate.AzureVmFamilyMSeries),
 * 					pulumi.String(migrate.AzureVmFamilyFsv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyHSeries),
 * 				},
 * 				Currency:           pulumi.String(migrate.CurrencyUSD),
 * 				DiscountPercentage: pulumi.Float64(100),
 * 				Percentile:         pulumi.String(migrate.PercentilePercentile95),
 * 				ReservedInstance:   pulumi.String(migrate.ReservedInstanceRI3Year),
 * 				ScalingFactor:      pulumi.Float64(1),
 * 				SizingCriterion:    pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 				Stage:              pulumi.String(migrate.AssessmentStageInProgress),
 * 				TimeRange:          pulumi.String(migrate.TimeRangeDay),
 * 				VmUptime: &migrate.VmUptimeArgs{
 * 					DaysPerMonth: pulumi.Float64(31),
 * 					HoursPerDay:  pulumi.Float64(24),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Assessment;
 * import com.pulumi.azurenative.migrate.AssessmentArgs;
 * import com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.VmUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessment = new Assessment("assessment", AssessmentArgs.builder()
 *             .assessmentName("assessment_5_14_2019_16_48_47")
 *             .eTag("\"1e000c2c-0000-0d00-0000-5cdaa4190000\"")
 *             .groupName("Group2")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(AssessmentPropertiesArgs.builder()
 *                 .azureDiskType("StandardOrPremium")
 *                 .azureHybridUseBenefit("Yes")
 *                 .azureLocation("NorthEurope")
 *                 .azureOfferCode("MSAZR0003P")
 *                 .azurePricingTier("Standard")
 *                 .azureStorageRedundancy("LocallyRedundant")
 *                 .azureVmFamilies(
 *                     "Dv2_series",
 *                     "F_series",
 *                     "Dv3_series",
 *                     "DS_series",
 *                     "DSv2_series",
 *                     "Fs_series",
 *                     "Dsv3_series",
 *                     "Ev3_series",
 *                     "Esv3_series",
 *                     "D_series",
 *                     "M_series",
 *                     "Fsv2_series",
 *                     "H_series")
 *                 .currency("USD")
 *                 .discountPercentage(100)
 *                 .percentile("Percentile95")
 *                 .reservedInstance("RI3Year")
 *                 .scalingFactor(1)
 *                 .sizingCriterion("PerformanceBased")
 *                 .stage("InProgress")
 *                 .timeRange("Day")
 *                 .vmUptime(VmUptimeArgs.builder()
 *                     .daysPerMonth(31)
 *                     .hoursPerDay(24)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("abgoyal-westEurope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Assessment assessment_5_14_2019_16_48_47 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}
 * ```
 */
public class Assessment internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.Assessment,
) : KotlinCustomResource(javaResource, AssessmentMapper) {
    /**
     * For optimistic concurrency control.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Unique name of an assessment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the assessment.
     */
    public val properties: Output<AssessmentPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the object = [Microsoft&#46;Migrate/assessmentProjects/groups/assessments].
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AssessmentMapper : ResourceMapper<Assessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.Assessment::class == javaResource::class

    override fun map(javaResource: Resource): Assessment = Assessment(
        javaResource as
            com.pulumi.azurenative.migrate.Assessment,
    )
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Assessment].
 */
public suspend fun assessment(name: String, block: suspend AssessmentResourceBuilder.() -> Unit):
    Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Assessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessment(name: String): Assessment {
    val builder = AssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
