@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.AssessmentArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.AssessmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An assessment created for a group in the Migration project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2017-11-11-preview, 2018-02-02.
 * ## Example Usage
 * ### Assessments_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessment = new AzureNative.Migrate.Assessment("assessment", new()
 *     {
 *         AssessmentName = "assessment_5_14_2019_16_48_47",
 *         ETag = "\"1e000c2c-0000-0d00-0000-5cdaa4190000\"",
 *         GroupName = "Group2",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.AssessmentPropertiesArgs
 *         {
 *             AzureDiskType = AzureNative.Migrate.AzureDiskType.StandardOrPremium,
 *             AzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Yes,
 *             AzureLocation = AzureNative.Migrate.AzureLocation.NorthEurope,
 *             AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Msazr0003P,
 *             AzurePricingTier = AzureNative.Migrate.AzurePricingTier.Standard,
 *             AzureStorageRedundancy = AzureNative.Migrate.AzureStorageRedundancy.LocallyRedundant,
 *             AzureVmFamilies = new[]
 *             {
 *                 AzureNative.Migrate.AzureVmFamily.Dv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.FSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Dv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.DSSeries,
 *                 AzureNative.Migrate.AzureVmFamily.DSv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.FsSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Dsv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.Ev3Series,
 *                 AzureNative.Migrate.AzureVmFamily.Esv3Series,
 *                 AzureNative.Migrate.AzureVmFamily.DSeries,
 *                 AzureNative.Migrate.AzureVmFamily.MSeries,
 *                 AzureNative.Migrate.AzureVmFamily.Fsv2Series,
 *                 AzureNative.Migrate.AzureVmFamily.HSeries,
 *             },
 *             Currency = AzureNative.Migrate.Currency.USD,
 *             DiscountPercentage = 100,
 *             Percentile = AzureNative.Migrate.Percentile.Percentile95,
 *             ReservedInstance = AzureNative.Migrate.ReservedInstance.RI3Year,
 *             ScalingFactor = 1,
 *             SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *             Stage = AzureNative.Migrate.AssessmentStage.InProgress,
 *             TimeRange = AzureNative.Migrate.TimeRange.Day,
 *             VmUptime = new AzureNative.Migrate.Inputs.VmUptimeArgs
 *             {
 *                 DaysPerMonth = 31,
 *                 HoursPerDay = 24,
 *             },
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessment(ctx, "assessment", &migrate.AssessmentArgs{
 * 			AssessmentName: pulumi.String("assessment_5_14_2019_16_48_47"),
 * 			ETag:           pulumi.String("\"1e000c2c-0000-0d00-0000-5cdaa4190000\""),
 * 			GroupName:      pulumi.String("Group2"),
 * 			ProjectName:    pulumi.String("abgoyalWEselfhostb72bproject"),
 * 			Properties: &migrate.AssessmentPropertiesArgs{
 * 				AzureDiskType:          pulumi.String(migrate.AzureDiskTypeStandardOrPremium),
 * 				AzureHybridUseBenefit:  pulumi.String(migrate.AzureHybridUseBenefitYes),
 * 				AzureLocation:          pulumi.String(migrate.AzureLocationNorthEurope),
 * 				AzureOfferCode:         pulumi.String(migrate.AzureOfferCodeMsazr0003P),
 * 				AzurePricingTier:       pulumi.String(migrate.AzurePricingTierStandard),
 * 				AzureStorageRedundancy: pulumi.String(migrate.AzureStorageRedundancyLocallyRedundant),
 * 				AzureVmFamilies: pulumi.StringArray{
 * 					pulumi.String(migrate.AzureVmFamilyDv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyFSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyDSSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDSv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyFsSeries),
 * 					pulumi.String(migrate.AzureVmFamilyDsv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyEv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyEsv3Series),
 * 					pulumi.String(migrate.AzureVmFamilyDSeries),
 * 					pulumi.String(migrate.AzureVmFamilyMSeries),
 * 					pulumi.String(migrate.AzureVmFamilyFsv2Series),
 * 					pulumi.String(migrate.AzureVmFamilyHSeries),
 * 				},
 * 				Currency:           pulumi.String(migrate.CurrencyUSD),
 * 				DiscountPercentage: pulumi.Float64(100),
 * 				Percentile:         pulumi.String(migrate.PercentilePercentile95),
 * 				ReservedInstance:   pulumi.String(migrate.ReservedInstanceRI3Year),
 * 				ScalingFactor:      pulumi.Float64(1),
 * 				SizingCriterion:    pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 				Stage:              pulumi.String(migrate.AssessmentStageInProgress),
 * 				TimeRange:          pulumi.String(migrate.TimeRangeDay),
 * 				VmUptime: &migrate.VmUptimeArgs{
 * 					DaysPerMonth: pulumi.Float64(31),
 * 					HoursPerDay:  pulumi.Float64(24),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Assessment;
 * import com.pulumi.azurenative.migrate.AssessmentArgs;
 * import com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.VmUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessment = new Assessment("assessment", AssessmentArgs.builder()
 *             .assessmentName("assessment_5_14_2019_16_48_47")
 *             .eTag("\"1e000c2c-0000-0d00-0000-5cdaa4190000\"")
 *             .groupName("Group2")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(AssessmentPropertiesArgs.builder()
 *                 .azureDiskType("StandardOrPremium")
 *                 .azureHybridUseBenefit("Yes")
 *                 .azureLocation("NorthEurope")
 *                 .azureOfferCode("MSAZR0003P")
 *                 .azurePricingTier("Standard")
 *                 .azureStorageRedundancy("LocallyRedundant")
 *                 .azureVmFamilies(
 *                     "Dv2_series",
 *                     "F_series",
 *                     "Dv3_series",
 *                     "DS_series",
 *                     "DSv2_series",
 *                     "Fs_series",
 *                     "Dsv3_series",
 *                     "Ev3_series",
 *                     "Esv3_series",
 *                     "D_series",
 *                     "M_series",
 *                     "Fsv2_series",
 *                     "H_series")
 *                 .currency("USD")
 *                 .discountPercentage(100)
 *                 .percentile("Percentile95")
 *                 .reservedInstance("RI3Year")
 *                 .scalingFactor(1)
 *                 .sizingCriterion("PerformanceBased")
 *                 .stage("InProgress")
 *                 .timeRange("Day")
 *                 .vmUptime(VmUptimeArgs.builder()
 *                     .daysPerMonth(31)
 *                     .hoursPerDay(24)
 *                     .build())
 *                 .build())
 *             .resourceGroupName("abgoyal-westEurope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Assessment assessment_5_14_2019_16_48_47 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}
 * ```
 * @property assessmentName Unique name of an assessment within a project.
 * @property eTag For optimistic concurrency control.
 * @property groupName Unique name of a group within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties Properties of the assessment.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class AssessmentArgs(
    public val assessmentName: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<AssessmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.AssessmentArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.AssessmentArgs =
        com.pulumi.azurenative.migrate.AssessmentArgs.builder()
            .assessmentName(assessmentName?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentArgs].
 */
@PulumiTagMarker
public class AssessmentArgsBuilder internal constructor() {
    private var assessmentName: Output<String>? = null

    private var eTag: Output<String>? = null

    private var groupName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<AssessmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Unique name of an assessment within a project.
     */
    @JvmName("mtswgkasyxkgqcop")
    public suspend fun assessmentName(`value`: Output<String>) {
        this.assessmentName = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("bstwsrecheknijht")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("mtpurnensgonqbmc")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("xpbnrqrqawflklhb")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Properties of the assessment.
     */
    @JvmName("gkaobjksqpsdaark")
    public suspend fun properties(`value`: Output<AssessmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("tlgesccaeaonkwid")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of an assessment within a project.
     */
    @JvmName("umisqliywudjsfob")
    public suspend fun assessmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentName = mapped
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("qmfsgoabdjrfdiag")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("ywjpawwfhifermyb")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("cyinqkhltriegmbs")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Properties of the assessment.
     */
    @JvmName("xfklsrntsjbnbfqg")
    public suspend fun properties(`value`: AssessmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the assessment.
     */
    @JvmName("pwqonfyaommfjtnt")
    public suspend fun properties(argument: suspend AssessmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("tmwryayvkccmghqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AssessmentArgs = AssessmentArgs(
        assessmentName = assessmentName,
        eTag = eTag,
        groupName = groupName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
