@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CostComponentResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.VmUptimeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.CostComponentResponse.Companion.toKotlin as costComponentResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.VmUptimeResponse.Companion.toKotlin as vmUptimeResponseToKotlin

/**
 * Builder for [AssessmentsOperation].
 */
@PulumiTagMarker
public class AssessmentsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentsOperationArgs = AssessmentsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentsOperationArgsBuilder.() -> Unit) {
        val builder = AssessmentsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AssessmentsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.AssessmentsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssessmentsOperation(builtJavaResource)
    }
}

/**
 * Machine assessment resource.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-03-15.
 * ## Example Usage
 * ### AssessmentsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentsOperation = new AzureNative.Migrate.AssessmentsOperation("assessmentsOperation", new()
 *     {
 *         AssessmentName = "asm1",
 *         AzureDiskTypes = new[]
 *         {
 *             AzureNative.Migrate.AzureDiskType.Premium,
 *             AzureNative.Migrate.AzureDiskType.StandardSSD,
 *         },
 *         AzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Unknown,
 *         AzureLocation = "njxbwdtsxzhichsnk",
 *         AzureOfferCode = AzureNative.Migrate.AzureOfferCode.Unknown,
 *         AzurePricingTier = AzureNative.Migrate.AzurePricingTier.Standard,
 *         AzureStorageRedundancy = AzureNative.Migrate.AzureStorageRedundancy.Unknown,
 *         AzureVmFamilies = new[]
 *         {
 *             AzureNative.Migrate.AzureVmFamily.DSeries,
 *             AzureNative.Migrate.AzureVmFamily.Lsv2Series,
 *             AzureNative.Migrate.AzureVmFamily.MSeries,
 *             AzureNative.Migrate.AzureVmFamily.Mdsv2Series,
 *             AzureNative.Migrate.AzureVmFamily.Msv2Series,
 *             AzureNative.Migrate.AzureVmFamily.Mv2Series,
 *         },
 *         Currency = AzureNative.Migrate.AzureCurrency.Unknown,
 *         DiscountPercentage = 6,
 *         EaSubscriptionId = "kwsu",
 *         GroupName = "kuchatur-test",
 *         LinuxAzureHybridUseBenefit = AzureNative.Migrate.AzureHybridUseBenefit.Unknown,
 *         Percentile = AzureNative.Migrate.Percentile.Percentile50,
 *         PerfDataEndTime = "2023-09-26T09:36:48.491Z",
 *         PerfDataStartTime = "2023-09-26T09:36:48.491Z",
 *         ProjectName = "app18700project",
 *         ProvisioningState = AzureNative.Migrate.ProvisioningState.Succeeded,
 *         ReservedInstance = AzureNative.Migrate.AzureReservedInstance.None,
 *         ResourceGroupName = "ayagrawrg",
 *         ScalingFactor = 24,
 *         SizingCriterion = AzureNative.Migrate.AssessmentSizingCriterion.PerformanceBased,
 *         TimeRange = AzureNative.Migrate.TimeRange.Day,
 *         VmUptime = new AzureNative.Migrate.Inputs.VmUptimeArgs
 *         {
 *             DaysPerMonth = 13,
 *             HoursPerDay = 26,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewAssessmentsOperation(ctx, "assessmentsOperation", &migrate.AssessmentsOperationArgs{
 * 			AssessmentName: pulumi.String("asm1"),
 * 			AzureDiskTypes: pulumi.StringArray{
 * 				pulumi.String(migrate.AzureDiskTypePremium),
 * 				pulumi.String(migrate.AzureDiskTypeStandardSSD),
 * 			},
 * 			AzureHybridUseBenefit:  pulumi.String(migrate.AzureHybridUseBenefitUnknown),
 * 			AzureLocation:          pulumi.String("njxbwdtsxzhichsnk"),
 * 			AzureOfferCode:         pulumi.String(migrate.AzureOfferCodeUnknown),
 * 			AzurePricingTier:       pulumi.String(migrate.AzurePricingTierStandard),
 * 			AzureStorageRedundancy: pulumi.String(migrate.AzureStorageRedundancyUnknown),
 * 			AzureVmFamilies: pulumi.StringArray{
 * 				pulumi.String(migrate.AzureVmFamilyDSeries),
 * 				pulumi.String(migrate.AzureVmFamilyLsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMSeries),
 * 				pulumi.String(migrate.AzureVmFamilyMdsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMsv2Series),
 * 				pulumi.String(migrate.AzureVmFamilyMv2Series),
 * 			},
 * 			Currency:                   pulumi.String(migrate.AzureCurrencyUnknown),
 * 			DiscountPercentage:         pulumi.Float64(6),
 * 			EaSubscriptionId:           pulumi.String("kwsu"),
 * 			GroupName:                  pulumi.String("kuchatur-test"),
 * 			LinuxAzureHybridUseBenefit: pulumi.String(migrate.AzureHybridUseBenefitUnknown),
 * 			Percentile:                 pulumi.String(migrate.PercentilePercentile50),
 * 			PerfDataEndTime:            pulumi.String("2023-09-26T09:36:48.491Z"),
 * 			PerfDataStartTime:          pulumi.String("2023-09-26T09:36:48.491Z"),
 * 			ProjectName:                pulumi.String("app18700project"),
 * 			ProvisioningState:          pulumi.String(migrate.ProvisioningStateSucceeded),
 * 			ReservedInstance:           pulumi.String(migrate.AzureReservedInstanceNone),
 * 			ResourceGroupName:          pulumi.String("ayagrawrg"),
 * 			ScalingFactor:              pulumi.Float64(24),
 * 			SizingCriterion:            pulumi.String(migrate.AssessmentSizingCriterionPerformanceBased),
 * 			TimeRange:                  pulumi.String(migrate.TimeRangeDay),
 * 			VmUptime: &migrate.VmUptimeArgs{
 * 				DaysPerMonth: pulumi.Float64(13),
 * 				HoursPerDay:  pulumi.Float64(26),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.AssessmentsOperation;
 * import com.pulumi.azurenative.migrate.AssessmentsOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.VmUptimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentsOperation = new AssessmentsOperation("assessmentsOperation", AssessmentsOperationArgs.builder()
 *             .assessmentName("asm1")
 *             .azureDiskTypes(
 *                 "Premium",
 *                 "StandardSSD")
 *             .azureHybridUseBenefit("Unknown")
 *             .azureLocation("njxbwdtsxzhichsnk")
 *             .azureOfferCode("Unknown")
 *             .azurePricingTier("Standard")
 *             .azureStorageRedundancy("Unknown")
 *             .azureVmFamilies(
 *                 "D_series",
 *                 "Lsv2_series",
 *                 "M_series",
 *                 "Mdsv2_series",
 *                 "Msv2_series",
 *                 "Mv2_series")
 *             .currency("Unknown")
 *             .discountPercentage(6)
 *             .eaSubscriptionId("kwsu")
 *             .groupName("kuchatur-test")
 *             .linuxAzureHybridUseBenefit("Unknown")
 *             .percentile("Percentile50")
 *             .perfDataEndTime("2023-09-26T09:36:48.491Z")
 *             .perfDataStartTime("2023-09-26T09:36:48.491Z")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .reservedInstance("None")
 *             .resourceGroupName("ayagrawrg")
 *             .scalingFactor(24)
 *             .sizingCriterion("PerformanceBased")
 *             .timeRange("Day")
 *             .vmUptime(VmUptimeArgs.builder()
 *                 .daysPerMonth(13)
 *                 .hoursPerDay(26)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:AssessmentsOperation asm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}
 * ```
 */
public class AssessmentsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.AssessmentsOperation,
) : KotlinCustomResource(javaResource, AssessmentsOperationMapper) {
    /**
     * Gets or sets the assessment error summary.
     *             This is the number of
     * machines affected by each type of error in this assessment.
     */
    public val assessmentErrorSummary: Output<Map<String, Int>>
        get() = javaResource.assessmentErrorSummary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Assessment type of the assessment.
     */
    public val assessmentType: Output<String>
        get() = javaResource.assessmentType().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the azure storage type. Premium, Standard etc.
     */
    public val azureDiskTypes: Output<List<String>>?
        get() = javaResource.azureDiskTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Gets or sets the user configurable setting to display the azure hybrid use
     * benefit.
     */
    public val azureHybridUseBenefit: Output<String>?
        get() = javaResource.azureHybridUseBenefit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Location or Azure region where to which the machines will be migrated.
     */
    public val azureLocation: Output<String>?
        get() = javaResource.azureLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Offer Code.
     */
    public val azureOfferCode: Output<String>?
        get() = javaResource.azureOfferCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets Azure Pricing Tier - Free, Basic, etc.
     */
    public val azurePricingTier: Output<String>?
        get() = javaResource.azurePricingTier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
     */
    public val azureStorageRedundancy: Output<String>?
        get() = javaResource.azureStorageRedundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the Azure VM families.
     */
    public val azureVmFamilies: Output<List<String>>?
        get() = javaResource.azureVmFamilies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Confidence Rating in Percentage.
     */
    public val confidenceRatingInPercentage: Output<Double>
        get() = javaResource.confidenceRatingInPercentage().applyValue({ args0 -> args0 })

    /**
     * Gets the collection of cost components.
     */
    public val costComponents: Output<List<CostComponentResponse>>
        get() = javaResource.costComponents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> costComponentResponseToKotlin(args0) })
            })
        })

    /**
     * Date and Time when assessment was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Currency in which prices should be reported.
     */
    public val currency: Output<String>?
        get() = javaResource.currency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Custom discount percentage.
     */
    public val discountPercentage: Output<Double>?
        get() = javaResource.discountPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the distribution by os name.
     */
    public val distributionByOsName: Output<Map<String, Int>>
        get() = javaResource.distributionByOsName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Gets the distribution distribution of sqlInstances by service pack insight.
     */
    public val distributionByServicePackInsight: Output<Map<String, Int>>
        get() = javaResource.distributionByServicePackInsight().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Gets the distribution of sqlInstances by support status.
     */
    public val distributionBySupportStatus: Output<Map<String, Int>>
        get() = javaResource.distributionBySupportStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Gets or sets enterprise agreement subscription id.
     */
    public val eaSubscriptionId: Output<String>?
        get() = javaResource.eaSubscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the group type for the assessment.
     */
    public val groupType: Output<String>
        get() = javaResource.groupType().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the user configurable setting to display the linux azure hybrid use
     * benefit.
     */
    public val linuxAzureHybridUseBenefit: Output<String>?
        get() = javaResource.linuxAzureHybridUseBenefit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the aggregate Bandwidth Cost for all machines in the assessment.
     */
    public val monthlyBandwidthCost: Output<Double>
        get() = javaResource.monthlyBandwidthCost().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the aggregate Compute Cost for all machines in the assessment.
     */
    public val monthlyComputeCost: Output<Double>
        get() = javaResource.monthlyComputeCost().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the aggregate premium storage cost for all machines in the
     * assessment.
     */
    public val monthlyPremiumStorageCost: Output<Double>
        get() = javaResource.monthlyPremiumStorageCost().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the aggregate standard SSD storage cost for all the machines in
     * the assessment.
     */
    public val monthlyStandardSsdStorageCost: Output<Double>
        get() = javaResource.monthlyStandardSsdStorageCost().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the aggregate Storage Cost for all machines in the assessment.
     */
    public val monthlyStorageCost: Output<Double>
        get() = javaResource.monthlyStorageCost().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the aggregate ultra storage cost for all machines in the
     * assessment.
     */
    public val monthlyUltraStorageCost: Output<Double>
        get() = javaResource.monthlyUltraStorageCost().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the Number of machines part of the assessment.
     */
    public val numberOfMachines: Output<Int>
        get() = javaResource.numberOfMachines().applyValue({ args0 -> args0 })

    /**
     * Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    public val percentile: Output<String>?
        get() = javaResource.percentile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the end time to consider performance data for assessment.
     */
    public val perfDataEndTime: Output<String>?
        get() = javaResource.perfDataEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the start time to consider performance data for assessment.
     */
    public val perfDataStartTime: Output<String>?
        get() = javaResource.perfDataStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time when rates were queried.
     */
    public val pricesTimestamp: Output<String>
        get() = javaResource.pricesTimestamp().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the Azure Reserved Instance - 1-Year, 3-Year.
     */
    public val reservedInstance: Output<String>?
        get() = javaResource.reservedInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    public val scalingFactor: Output<Double>?
        get() = javaResource.scalingFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schema version.
     */
    public val schemaVersion: Output<String>
        get() = javaResource.schemaVersion().applyValue({ args0 -> args0 })

    /**
     * Assessment sizing criterion.
     */
    public val sizingCriterion: Output<String>?
        get() = javaResource.sizingCriterion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User configurable setting to display the Stage of Assessment.
     */
    public val stage: Output<String>
        get() = javaResource.stage().applyValue({ args0 -> args0 })

    /**
     * Whether assessment is in valid state and all machines have been assessed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the Cloud suitability summary for all the machines in the
     * assessment.
     */
    public val suitabilitySummary: Output<Map<String, Int>>
        get() = javaResource.suitabilitySummary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    public val timeRange: Output<String>?
        get() = javaResource.timeRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Date and Time when assessment was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the duration for which the VMs are up in the on-premises
     * environment.
     */
    public val vmUptime: Output<VmUptimeResponse>?
        get() = javaResource.vmUptime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    vmUptimeResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AssessmentsOperationMapper : ResourceMapper<AssessmentsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.AssessmentsOperation::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentsOperation = AssessmentsOperation(
        javaResource
            as com.pulumi.azurenative.migrate.AssessmentsOperation,
    )
}

/**
 * @see [AssessmentsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentsOperation].
 */
public suspend fun assessmentsOperation(
    name: String,
    block: suspend AssessmentsOperationResourceBuilder.() -> Unit,
): AssessmentsOperation {
    val builder = AssessmentsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentsOperation(name: String): AssessmentsOperation {
    val builder = AssessmentsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
