@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [HyperVCollector].
 */
@PulumiTagMarker
public class HyperVCollectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HyperVCollectorArgs = HyperVCollectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HyperVCollectorArgsBuilder.() -> Unit) {
        val builder = HyperVCollectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): HyperVCollector {
        val builtJavaResource = com.pulumi.azurenative.migrate.HyperVCollector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return HyperVCollector(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### HyperVCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hyperVCollector = new AzureNative.Migrate.HyperVCollector("hyperVCollector", new()
 *     {
 *         ETag = "\"00000981-0000-0300-0000-5d74cd5f0000\"",
 *         HyperVCollectorName = "migrateprojectce73collector",
 *         ProjectName = "migrateprojectce73project",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "827f1053-44dc-439f-b832-05416dcce12b",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "be75098e-c0fc-4ac4-98c7-282ebbcf8370",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site",
 *         },
 *         ResourceGroupName = "contosoithyperv",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewHyperVCollector(ctx, "hyperVCollector", &migrate.HyperVCollectorArgs{
 * 			ETag:                pulumi.String("\"00000981-0000-0300-0000-5d74cd5f0000\""),
 * 			HyperVCollectorName: pulumi.String("migrateprojectce73collector"),
 * 			ProjectName:         pulumi.String("migrateprojectce73project"),
 * 			Properties: &migrate.CollectorPropertiesArgs{
 * 				AgentProperties: &migrate.CollectorAgentPropertiesArgs{
 * 					SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * 						ApplicationId: pulumi.String("827f1053-44dc-439f-b832-05416dcce12b"),
 * 						Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp"),
 * 						Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 						ObjectId:      pulumi.String("be75098e-c0fc-4ac4-98c7-282ebbcf8370"),
 * 						TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					},
 * 				},
 * 				DiscoverySiteId: pulumi.String("/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contosoithyperv"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.HyperVCollector;
 * import com.pulumi.azurenative.migrate.HyperVCollectorArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hyperVCollector = new HyperVCollector("hyperVCollector", HyperVCollectorArgs.builder()
 *             .eTag("\"00000981-0000-0300-0000-5d74cd5f0000\"")
 *             .hyperVCollectorName("migrateprojectce73collector")
 *             .projectName("migrateprojectce73project")
 *             .properties(CollectorPropertiesArgs.builder()
 *                 .agentProperties(CollectorAgentPropertiesArgs.builder()
 *                     .spnDetails(CollectorBodyAgentSpnPropertiesArgs.builder()
 *                         .applicationId("827f1053-44dc-439f-b832-05416dcce12b")
 *                         .audience("https://72f988bf-86f1-41af-91ab-2d7cd011db47/migrateprojectce73agentauthaadapp")
 *                         .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .objectId("be75098e-c0fc-4ac4-98c7-282ebbcf8370")
 *                         .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .build())
 *                     .build())
 *                 .discoverySiteId("/subscriptions/8c3c936a-c09b-4de3-830b-3f5f244d72e9/resourceGroups/ContosoITHyperV/providers/Microsoft.OffAzure/HyperVSites/migrateprojectce73site")
 *                 .build())
 *             .resourceGroupName("contosoithyperv")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:HyperVCollector migrateprojectce73collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/hypervcollectors/{hyperVCollectorName}
 * ```
 */
public class HyperVCollector internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.HyperVCollector,
) : KotlinCustomResource(javaResource, HyperVCollectorMapper) {
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<CollectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object HyperVCollectorMapper : ResourceMapper<HyperVCollector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.HyperVCollector::class == javaResource::class

    override fun map(javaResource: Resource): HyperVCollector = HyperVCollector(
        javaResource as
            com.pulumi.azurenative.migrate.HyperVCollector,
    )
}

/**
 * @see [HyperVCollector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HyperVCollector].
 */
public suspend fun hyperVCollector(
    name: String,
    block: suspend HyperVCollectorResourceBuilder.() -> Unit,
): HyperVCollector {
    val builder = HyperVCollectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HyperVCollector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hyperVCollector(name: String): HyperVCollector {
    val builder = HyperVCollectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
