@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ImportCollectorArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.ImportCollectorPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.ImportCollectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### ImportCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importCollector = new AzureNative.Migrate.ImportCollector("importCollector", new()
 *     {
 *         ImportCollectorName = "importCollector2952",
 *         ProjectName = "rajoshCCY9671project",
 *         ResourceGroupName = "markusavstestrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewImportCollector(ctx, "importCollector", &migrate.ImportCollectorArgs{
 * 			ImportCollectorName: pulumi.String("importCollector2952"),
 * 			ProjectName:         pulumi.String("rajoshCCY9671project"),
 * 			ResourceGroupName:   pulumi.String("markusavstestrg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ImportCollector;
 * import com.pulumi.azurenative.migrate.ImportCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importCollector = new ImportCollector("importCollector", ImportCollectorArgs.builder()
 *             .importCollectorName("importCollector2952")
 *             .projectName("rajoshCCY9671project")
 *             .resourceGroupName("markusavstestrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ImportCollector importCollector2952 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/importcollectors/{importCollectorName}
 * ```
 * @property eTag
 * @property importCollectorName Unique name of a Import collector within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class ImportCollectorArgs(
    public val eTag: Output<String>? = null,
    public val importCollectorName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<ImportCollectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ImportCollectorArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ImportCollectorArgs =
        com.pulumi.azurenative.migrate.ImportCollectorArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .importCollectorName(importCollectorName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImportCollectorArgs].
 */
@PulumiTagMarker
public class ImportCollectorArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var importCollectorName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<ImportCollectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ksmqaonijymuknrw")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a Import collector within a project.
     */
    @JvmName("xfbqpstfyevclvlt")
    public suspend fun importCollectorName(`value`: Output<String>) {
        this.importCollectorName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("gjhfrlvexaqxuatb")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value
     */
    @JvmName("oqrdfjsrjoxgblkv")
    public suspend fun properties(`value`: Output<ImportCollectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("chwjbsbnbxesocbv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("nesffuxtsbcqcjkf")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a Import collector within a project.
     */
    @JvmName("rfwldqtffijggeiq")
    public suspend fun importCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importCollectorName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("kcshsuqhomyjextv")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value
     */
    @JvmName("hgtvghojrvomlhja")
    public suspend fun properties(`value`: ImportCollectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yihxchtyrhbwwjhv")
    public suspend fun properties(argument: suspend ImportCollectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ImportCollectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("gxvtwwvklqxhlbrn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ImportCollectorArgs = ImportCollectorArgs(
        eTag = eTag,
        importCollectorName = importCollectorName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
