@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectResponseTags
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse.Companion.toKotlin as migrateProjectPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectResponseTags.Companion.toKotlin as migrateProjectResponseTagsToKotlin

/**
 * Builder for [MigrateProject].
 */
@PulumiTagMarker
public class MigrateProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrateProjectArgs = MigrateProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MigrateProjectArgsBuilder.() -> Unit) {
        val builder = MigrateProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MigrateProject {
        val builtJavaResource = com.pulumi.azurenative.migrate.MigrateProject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MigrateProject(builtJavaResource)
    }
}

/**
 * Migrate Project REST Resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### MigrateProjects_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateProject = new AzureNative.Migrate.MigrateProject("migrateProject", new()
 *     {
 *         ETag = "\"b701c73a-0000-0000-0000-59c12ff00000\"",
 *         Location = "Southeast Asia",
 *         MigrateProjectName = "project01",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateProject(ctx, "migrateProject", &migrate.MigrateProjectArgs{
 * 			ETag:               pulumi.String("\"b701c73a-0000-0000-0000-59c12ff00000\""),
 * 			Location:           pulumi.String("Southeast Asia"),
 * 			MigrateProjectName: pulumi.String("project01"),
 * 			Properties:         nil,
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateProject;
 * import com.pulumi.azurenative.migrate.MigrateProjectArgs;
 * import com.pulumi.azurenative.migrate.inputs.MigrateProjectPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.MigrateProjectTagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateProject = new MigrateProject("migrateProject", MigrateProjectArgs.builder()
 *             .eTag("\"b701c73a-0000-0000-0000-59c12ff00000\"")
 *             .location("Southeast Asia")
 *             .migrateProjectName("project01")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateProject project01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}
 * ```
 */
public class MigrateProject internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.MigrateProject,
) : KotlinCustomResource(javaResource, MigrateProjectMapper) {
    /**
     * Gets or sets the eTag for concurrency control.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the Azure location in which migrate project is created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the name of the migrate project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the nested properties.
     */
    public val properties: Output<MigrateProjectPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                migrateProjectPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Gets or sets the tags.
     */
    public val tags: Output<MigrateProjectResponseTags>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    migrateProjectResponseTagsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Handled by resource provider. Type = Microsoft.Migrate/MigrateProject.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MigrateProjectMapper : ResourceMapper<MigrateProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.MigrateProject::class == javaResource::class

    override fun map(javaResource: Resource): MigrateProject = MigrateProject(
        javaResource as
            com.pulumi.azurenative.migrate.MigrateProject,
    )
}

/**
 * @see [MigrateProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrateProject].
 */
public suspend fun migrateProject(
    name: String,
    block: suspend MigrateProjectResourceBuilder.() -> Unit,
): MigrateProject {
    val builder = MigrateProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrateProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrateProject(name: String): MigrateProject {
    val builder = MigrateProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
