@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.MoveCollectionPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.migrate.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.MoveCollectionPropertiesResponse.Companion.toKotlin as moveCollectionPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MoveCollection].
 */
@PulumiTagMarker
public class MoveCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MoveCollectionArgs = MoveCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MoveCollectionArgsBuilder.() -> Unit) {
        val builder = MoveCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MoveCollection {
        val builtJavaResource = com.pulumi.azurenative.migrate.MoveCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MoveCollection(builtJavaResource)
    }
}

/**
 * Define the move collection.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### MoveCollections_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var moveCollection = new AzureNative.Migrate.MoveCollection("moveCollection", new()
 *     {
 *         Identity = new AzureNative.Migrate.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.Migrate.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus2",
 *         MoveCollectionName = "movecollection1",
 *         Properties = new AzureNative.Migrate.Inputs.MoveCollectionPropertiesArgs
 *         {
 *             SourceRegion = "eastus",
 *             TargetRegion = "westus",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMoveCollection(ctx, "moveCollection", &migrate.MoveCollectionArgs{
 * 			Identity: &migrate.IdentityArgs{
 * 				Type: pulumi.String(migrate.ResourceIdentityTypeSystemAssigned),
 * 			},
 * 			Location:           pulumi.String("eastus2"),
 * 			MoveCollectionName: pulumi.String("movecollection1"),
 * 			Properties: &migrate.MoveCollectionPropertiesArgs{
 * 				SourceRegion: pulumi.String("eastus"),
 * 				TargetRegion: pulumi.String("westus"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MoveCollection;
 * import com.pulumi.azurenative.migrate.MoveCollectionArgs;
 * import com.pulumi.azurenative.migrate.inputs.IdentityArgs;
 * import com.pulumi.azurenative.migrate.inputs.MoveCollectionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var moveCollection = new MoveCollection("moveCollection", MoveCollectionArgs.builder()
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus2")
 *             .moveCollectionName("movecollection1")
 *             .properties(MoveCollectionPropertiesArgs.builder()
 *                 .sourceRegion("eastus")
 *                 .targetRegion("westus")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MoveCollection movecollection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}
 * ```
 */
public class MoveCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.MoveCollection,
) : KotlinCustomResource(javaResource, MoveCollectionMapper) {
    /**
     * The etag of the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Defines the MSI properties of the Move Collection.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the move collection properties.
     */
    public val properties: Output<MoveCollectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                moveCollectionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MoveCollectionMapper : ResourceMapper<MoveCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.MoveCollection::class == javaResource::class

    override fun map(javaResource: Resource): MoveCollection = MoveCollection(
        javaResource as
            com.pulumi.azurenative.migrate.MoveCollection,
    )
}

/**
 * @see [MoveCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MoveCollection].
 */
public suspend fun moveCollection(
    name: String,
    block: suspend MoveCollectionResourceBuilder.() -> Unit,
): MoveCollection {
    val builder = MoveCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MoveCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun moveCollection(name: String): MoveCollection {
    val builder = MoveCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
