@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.ConnectionStateRequestBodyPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.ConnectionStateRequestBodyPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * REST model used to encapsulate the user visible state of a PrivateEndpoint.
 * Azure REST API version: 2020-05-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### PrivateEndpointConnection_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionControllerPrivateEndpointConnection = new AzureNative.Migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection("privateEndpointConnectionControllerPrivateEndpointConnection", new()
 *     {
 *         MigrateProjectName = "proj567",
 *         PeConnectionName = "proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6",
 *         Properties = new AzureNative.Migrate.Inputs.ConnectionStateRequestBodyPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Migrate.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 ActionsRequired = "",
 *                 Status = AzureNative.Migrate.PrivateEndpointServiceConnectionStatus.Approved,
 *             },
 *         },
 *         ResourceGroupName = "pajindTest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionControllerPrivateEndpointConnection(ctx, "privateEndpointConnectionControllerPrivateEndpointConnection", &migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs{
 * 			MigrateProjectName: pulumi.String("proj567"),
 * 			PeConnectionName:   pulumi.String("proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6"),
 * 			Properties: &migrate.ConnectionStateRequestBodyPropertiesArgs{
 * 				PrivateLinkServiceConnectionState: &migrate.PrivateLinkServiceConnectionStateArgs{
 * 					ActionsRequired: pulumi.String(""),
 * 					Status:          pulumi.String(migrate.PrivateEndpointServiceConnectionStatusApproved),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnection;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.migrate.inputs.ConnectionStateRequestBodyPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionControllerPrivateEndpointConnection = new PrivateEndpointConnectionControllerPrivateEndpointConnection("privateEndpointConnectionControllerPrivateEndpointConnection", PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.builder()
 *             .migrateProjectName("proj567")
 *             .peConnectionName("proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6")
 *             .properties(ConnectionStateRequestBodyPropertiesArgs.builder()
 *                 .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                     .actionsRequired("")
 *                     .status("Approved")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("pajindTest1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionControllerPrivateEndpointConnection proj5675162pe.fdccace0-e303-4a79-80c8-3aa7c1f09cc6 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/privateEndpointConnections/{peConnectionName}
 * ```
 * @property eTag Gets the tag for optimistic concurrency control.
 * @property migrateProjectName Migrate project name.
 * @property peConnectionName Private endpoint connection name.
 * @property properties Properties of Connection state request.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs(
    public val eTag: Output<String>? = null,
    public val migrateProjectName: Output<String>? = null,
    public val peConnectionName: Output<String>? = null,
    public val properties: Output<ConnectionStateRequestBodyPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .peConnectionName(peConnectionName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionControllerPrivateEndpointConnectionArgsBuilder internal
constructor() {
    private var eTag: Output<String>? = null

    private var migrateProjectName: Output<String>? = null

    private var peConnectionName: Output<String>? = null

    private var properties: Output<ConnectionStateRequestBodyPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Gets the tag for optimistic concurrency control.
     */
    @JvmName("mmhushfeywfxpxss")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Migrate project name.
     */
    @JvmName("obggmpekgdkjojjv")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Private endpoint connection name.
     */
    @JvmName("pvlrjowhqrmfifrm")
    public suspend fun peConnectionName(`value`: Output<String>) {
        this.peConnectionName = value
    }

    /**
     * @param value Properties of Connection state request.
     */
    @JvmName("rwcikdheprmmmece")
    public suspend fun properties(`value`: Output<ConnectionStateRequestBodyPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("frsevtrjicfhsjls")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets the tag for optimistic concurrency control.
     */
    @JvmName("xvhjcfwlfspguhsn")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Migrate project name.
     */
    @JvmName("fouhmiknsusxttac")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Private endpoint connection name.
     */
    @JvmName("ucnxaqywkfayhdeh")
    public suspend fun peConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peConnectionName = mapped
    }

    /**
     * @param value Properties of Connection state request.
     */
    @JvmName("cnrykpqilakkltvk")
    public suspend fun properties(`value`: ConnectionStateRequestBodyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Connection state request.
     */
    @JvmName("subvhjvfadvqefeb")
    public suspend
    fun properties(argument: suspend ConnectionStateRequestBodyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateRequestBodyPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("jaqkmthsrxvurnaw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs =
        PrivateEndpointConnectionControllerPrivateEndpointConnectionArgs(
            eTag = eTag,
            migrateProjectName = migrateProjectName,
            peConnectionName = peConnectionName,
            properties = properties,
            resourceGroupName = resourceGroupName,
        )
}
