@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Private endpoint connection resource.
 * Azure REST API version: 2023-03-15.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnectionOperations_Update_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionOperation = new AzureNative.Migrate.PrivateEndpointConnectionOperation("privateEndpointConnectionOperation", new()
 *     {
 *         PrivateEndpointConnectionName = "sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7",
 *         PrivateLinkServiceConnectionState = new AzureNative.Migrate.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "",
 *             Status = AzureNative.Migrate.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ProjectName = "sakanwar1204project",
 *         ResourceGroupName = "sakanwar",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionOperation(ctx, "privateEndpointConnectionOperation", &migrate.PrivateEndpointConnectionOperationArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7"),
 * 			PrivateLinkServiceConnectionState: &migrate.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String(""),
 * 				Status:          pulumi.String(migrate.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ProjectName:       pulumi.String("sakanwar1204project"),
 * 			ResourceGroupName: pulumi.String("sakanwar"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperation;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs;
 * import com.pulumi.azurenative.migrate.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionOperation = new PrivateEndpointConnectionOperation("privateEndpointConnectionOperation", PrivateEndpointConnectionOperationArgs.builder()
 *             .privateEndpointConnectionName("sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .actionsRequired("")
 *                 .status("Approved")
 *                 .build())
 *             .projectName("sakanwar1204project")
 *             .resourceGroupName("sakanwar")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionOperation sakanwar1204project1634pe.bf42f8a1-09f5-4ee4-aea6-a019cc60f9d7 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName Private endpoint connection ARM name
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionOperationArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionOperationArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionOperationArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionOperationArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Private endpoint connection ARM name
     */
    @JvmName("wuhoeklbklsnrafj")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("gjhglmyrfiysxkno")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("slmhxcsyfryvtaff")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nolbitoecchoswxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Private endpoint connection ARM name
     */
    @JvmName("nlfdeejsgstvvqye")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("qnmasimlapabxodm")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("ulxxwvfuuvrtbwjg")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("pwblveauqebphlcj")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("srbqghgfjlvgfcdi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionOperationArgs =
        PrivateEndpointConnectionOperationArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
        )
}
