@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionProxyPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionProxyPropertiesResponse.Companion.toKotlin as privateEndpointConnectionProxyPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionProxyController].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionProxyControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionProxyControllerArgs =
        PrivateEndpointConnectionProxyControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PrivateEndpointConnectionProxyControllerArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionProxyControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionProxyController {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionProxyController(builtJavaResource)
    }
}

/**
 * Defines Private endpoint proxy resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### PrivateEndpointConnectionProxyController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxyController = new AzureNative.Migrate.PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", new()
 *     {
 *         ETag = "ftvkdifbymdoybmuhqocd",
 *         MigrateProjectName = "1GQwlI-",
 *         PecProxyName = "R-0-fb4",
 *         ResourceGroupName = "rghubmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionProxyController(ctx, "privateEndpointConnectionProxyController", &migrate.PrivateEndpointConnectionProxyControllerArgs{
 * 			ETag:               pulumi.String("ftvkdifbymdoybmuhqocd"),
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			PecProxyName:       pulumi.String("R-0-fb4"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxyController = new PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", PrivateEndpointConnectionProxyControllerArgs.builder()
 *             .eTag("ftvkdifbymdoybmuhqocd")
 *             .migrateProjectName("1GQwlI-")
 *             .pecProxyName("R-0-fb4")
 *             .resourceGroupName("rghubmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateEndpointConnectionProxyController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxyController = new AzureNative.Migrate.PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         PecProxyName = "z1LfRIz4-M2-1-V7",
 *         ResourceGroupName = "rghubmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionProxyController(ctx, "privateEndpointConnectionProxyController", &migrate.PrivateEndpointConnectionProxyControllerArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			PecProxyName:       pulumi.String("z1LfRIz4-M2-1-V7"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxyController = new PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", PrivateEndpointConnectionProxyControllerArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .pecProxyName("z1LfRIz4-M2-1-V7")
 *             .resourceGroupName("rghubmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionProxyController nyhzzglzyqbonqqlufludcaaocu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/privateEndpointConnectionProxies/{pecProxyName}
 * ```
 */
public class PrivateEndpointConnectionProxyController internal constructor(
    override val javaResource:
    com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionProxyControllerMapper) {
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a private endpoint connection proxy.
     */
    public val properties: Output<PrivateEndpointConnectionProxyPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointConnectionProxyPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionProxyControllerMapper :
    ResourceMapper<PrivateEndpointConnectionProxyController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionProxyController =
        PrivateEndpointConnectionProxyController(
            javaResource as
                com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController,
        )
}

/**
 * @see [PrivateEndpointConnectionProxyController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionProxyController].
 */
public suspend fun privateEndpointConnectionProxyController(
    name: String,
    block: suspend PrivateEndpointConnectionProxyControllerResourceBuilder.() -> Unit,
):
    PrivateEndpointConnectionProxyController {
    val builder = PrivateEndpointConnectionProxyControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionProxyController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionProxyController(name: String):
    PrivateEndpointConnectionProxyController {
    val builder = PrivateEndpointConnectionProxyControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
