@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines Private endpoint proxy resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### PrivateEndpointConnectionProxyController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxyController = new AzureNative.Migrate.PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", new()
 *     {
 *         ETag = "ftvkdifbymdoybmuhqocd",
 *         MigrateProjectName = "1GQwlI-",
 *         PecProxyName = "R-0-fb4",
 *         ResourceGroupName = "rghubmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionProxyController(ctx, "privateEndpointConnectionProxyController", &migrate.PrivateEndpointConnectionProxyControllerArgs{
 * 			ETag:               pulumi.String("ftvkdifbymdoybmuhqocd"),
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			PecProxyName:       pulumi.String("R-0-fb4"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxyController = new PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", PrivateEndpointConnectionProxyControllerArgs.builder()
 *             .eTag("ftvkdifbymdoybmuhqocd")
 *             .migrateProjectName("1GQwlI-")
 *             .pecProxyName("R-0-fb4")
 *             .resourceGroupName("rghubmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ### PrivateEndpointConnectionProxyController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionProxyController = new AzureNative.Migrate.PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         PecProxyName = "z1LfRIz4-M2-1-V7",
 *         ResourceGroupName = "rghubmigrate",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnectionProxyController(ctx, "privateEndpointConnectionProxyController", &migrate.PrivateEndpointConnectionProxyControllerArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			PecProxyName:       pulumi.String("z1LfRIz4-M2-1-V7"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyController;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionProxyController = new PrivateEndpointConnectionProxyController("privateEndpointConnectionProxyController", PrivateEndpointConnectionProxyControllerArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .pecProxyName("z1LfRIz4-M2-1-V7")
 *             .resourceGroupName("rghubmigrate")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnectionProxyController nyhzzglzyqbonqqlufludcaaocu /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/privateEndpointConnectionProxies/{pecProxyName}
 * ```
 * @property eTag
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property pecProxyName Private endpoint proxy name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionProxyControllerArgs(
    public val eTag: Output<String>? = null,
    public val migrateProjectName: Output<String>? = null,
    public val pecProxyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionProxyControllerArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .pecProxyName(pecProxyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionProxyControllerArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionProxyControllerArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var migrateProjectName: Output<String>? = null

    private var pecProxyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ihwrmbtceyqgcuso")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("qiucpdpmsbucnjik")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Private endpoint proxy name.
     */
    @JvmName("kjyvbobrrfktrxmi")
    public suspend fun pecProxyName(`value`: Output<String>) {
        this.pecProxyName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oovhuxnooogyjoqo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("yunlpdwypdayuflh")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("qxqiknolypelsaht")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Private endpoint proxy name.
     */
    @JvmName("cotijntavjlrxxnl")
    public suspend fun pecProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pecProxyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jquvhpkgidtkydqa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionProxyControllerArgs =
        PrivateEndpointConnectionProxyControllerArgs(
            eTag = eTag,
            migrateProjectName = migrateProjectName,
            pecProxyName = pecProxyName,
            resourceGroupName = resourceGroupName,
        )
}
