@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerCollector].
 */
@PulumiTagMarker
public class ServerCollectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerCollectorArgs = ServerCollectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerCollectorArgsBuilder.() -> Unit) {
        val builder = ServerCollectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerCollector {
        val builtJavaResource = com.pulumi.azurenative.migrate.ServerCollector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerCollector(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### ServerCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCollector = new AzureNative.Migrate.ServerCollector("serverCollector", new()
 *     {
 *         ETag = "\"00000606-0000-0d00-0000-605999bf0000\"",
 *         ProjectName = "app11141project",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "ad9f701a-cc08-4421-b51f-b5762d58e9ba",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "b4975e42-9248-4a36-b99f-37eca377ea00",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site",
 *         },
 *         ResourceGroupName = "pajindtest",
 *         ServerCollectorName = "app23df4collector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewServerCollector(ctx, "serverCollector", &migrate.ServerCollectorArgs{
 * 			ETag:        pulumi.String("\"00000606-0000-0d00-0000-605999bf0000\""),
 * 			ProjectName: pulumi.String("app11141project"),
 * 			Properties: &migrate.CollectorPropertiesArgs{
 * 				AgentProperties: &migrate.CollectorAgentPropertiesArgs{
 * 					SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * 						ApplicationId: pulumi.String("ad9f701a-cc08-4421-b51f-b5762d58e9ba"),
 * 						Audience:      pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp"),
 * 						Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 						ObjectId:      pulumi.String("b4975e42-9248-4a36-b99f-37eca377ea00"),
 * 						TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					},
 * 				},
 * 				DiscoverySiteId: pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("pajindtest"),
 * 			ServerCollectorName: pulumi.String("app23df4collector"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ServerCollector;
 * import com.pulumi.azurenative.migrate.ServerCollectorArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.CollectorBodyAgentSpnPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCollector = new ServerCollector("serverCollector", ServerCollectorArgs.builder()
 *             .eTag("\"00000606-0000-0d00-0000-605999bf0000\"")
 *             .projectName("app11141project")
 *             .properties(CollectorPropertiesArgs.builder()
 *                 .agentProperties(CollectorAgentPropertiesArgs.builder()
 *                     .spnDetails(CollectorBodyAgentSpnPropertiesArgs.builder()
 *                         .applicationId("ad9f701a-cc08-4421-b51f-b5762d58e9ba")
 *                         .audience("https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp")
 *                         .authority("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .objectId("b4975e42-9248-4a36-b99f-37eca377ea00")
 *                         .tenantId("72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                         .build())
 *                     .build())
 *                 .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site")
 *                 .build())
 *             .resourceGroupName("pajindtest")
 *             .serverCollectorName("app23df4collector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ServerCollector app23df4collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}
 * ```
 */
public class ServerCollector internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.ServerCollector,
) : KotlinCustomResource(javaResource, ServerCollectorMapper) {
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<CollectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerCollectorMapper : ResourceMapper<ServerCollector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.ServerCollector::class == javaResource::class

    override fun map(javaResource: Resource): ServerCollector = ServerCollector(
        javaResource as
            com.pulumi.azurenative.migrate.ServerCollector,
    )
}

/**
 * @see [ServerCollector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerCollector].
 */
public suspend fun serverCollector(
    name: String,
    block: suspend ServerCollectorResourceBuilder.() -> Unit,
): ServerCollector {
    val builder = ServerCollectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerCollector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverCollector(name: String): ServerCollector {
    val builder = ServerCollectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
