@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.SolutionArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.SolutionPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SolutionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Solution REST Resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### Solutions_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.Migrate.Solution("solution", new()
 *     {
 *         MigrateProjectName = "project01",
 *         Properties = new AzureNative.Migrate.Inputs.SolutionPropertiesArgs
 *         {
 *             Goal = AzureNative.Migrate.Goal.Databases,
 *             Purpose = AzureNative.Migrate.Purpose.Assessment,
 *             Tool = AzureNative.Migrate.Tool.DataMigrationAssistant,
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SolutionName = "dbsolution",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolution(ctx, "solution", &migrate.SolutionArgs{
 * 			MigrateProjectName: pulumi.String("project01"),
 * 			Properties: &migrate.SolutionPropertiesArgs{
 * 				Goal:    pulumi.String(migrate.GoalDatabases),
 * 				Purpose: pulumi.String(migrate.PurposeAssessment),
 * 				Tool:    pulumi.String(migrate.ToolDataMigrationAssistant),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SolutionName:      pulumi.String("dbsolution"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.Solution;
 * import com.pulumi.azurenative.migrate.SolutionArgs;
 * import com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .migrateProjectName("project01")
 *             .properties(SolutionPropertiesArgs.builder()
 *                 .goal("Databases")
 *                 .purpose("Assessment")
 *                 .tool("DataMigrationAssistant")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .solutionName("dbsolution")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:Solution dbsolution /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/solutions/{solutionName}
 * ```
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property properties Gets or sets the properties of the solution.
 * @property resourceGroupName Name of the Azure Resource Group that migrate project is part of.
 * @property solutionName Unique name of a migration solution within a migrate project.
 */
public data class SolutionArgs(
    public val migrateProjectName: Output<String>? = null,
    public val properties: Output<SolutionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val solutionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.SolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.SolutionArgs =
        com.pulumi.azurenative.migrate.SolutionArgs.builder()
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .solutionName(solutionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionArgs].
 */
@PulumiTagMarker
public class SolutionArgsBuilder internal constructor() {
    private var migrateProjectName: Output<String>? = null

    private var properties: Output<SolutionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var solutionName: Output<String>? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("kgiqbbriyjwotbfr")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Gets or sets the properties of the solution.
     */
    @JvmName("drpvmxlqhwoddosn")
    public suspend fun properties(`value`: Output<SolutionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that migrate project is part of.
     */
    @JvmName("hxaswybwqkrxfgqv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of a migration solution within a migrate project.
     */
    @JvmName("orfkcisyawiwiplm")
    public suspend fun solutionName(`value`: Output<String>) {
        this.solutionName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("xnxkletanvoxkicx")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Gets or sets the properties of the solution.
     */
    @JvmName("ccrwhihlcnlxcdyy")
    public suspend fun properties(`value`: SolutionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the properties of the solution.
     */
    @JvmName("erchcmcwjsfyhvwv")
    public suspend fun properties(argument: suspend SolutionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that migrate project is part of.
     */
    @JvmName("ormfxkyelmofvkvy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a migration solution within a migrate project.
     */
    @JvmName("jxwqwghlixasyqts")
    public suspend fun solutionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionName = mapped
    }

    internal fun build(): SolutionArgs = SolutionArgs(
        migrateProjectName = migrateProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        solutionName = solutionName,
    )
}
