@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.SolutionPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SolutionsControllerSolution].
 */
@PulumiTagMarker
public class SolutionsControllerSolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SolutionsControllerSolutionArgs = SolutionsControllerSolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SolutionsControllerSolutionArgsBuilder.() -> Unit) {
        val builder = SolutionsControllerSolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SolutionsControllerSolution {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.SolutionsControllerSolution(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SolutionsControllerSolution(builtJavaResource)
    }
}

/**
 * Solution REST Resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### SolutionsController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solutionsControllerSolution = new AzureNative.Migrate.SolutionsControllerSolution("solutionsControllerSolution", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         Properties = new AzureNative.Migrate.Inputs.SolutionPropertiesArgs
 *         {
 *             CleanupState = AzureNative.Migrate.CleanupState.None,
 *             Details = new AzureNative.Migrate.Inputs.SolutionDetailsArgs
 *             {
 *                 AssessmentCount = 7,
 *                 ExtendedDetails =
 *                 {
 *                     { "key9031", "ombnjq" },
 *                 },
 *                 GroupCount = 30,
 *             },
 *             Goal = AzureNative.Migrate.Goal.Servers,
 *             Purpose = AzureNative.Migrate.Purpose.Discovery,
 *             Status = AzureNative.Migrate.Status.Inactive,
 *             Tool = AzureNative.Migrate.Tool.ServerDiscovery,
 *         },
 *         ResourceGroupName = "rghubmigrate",
 *         SolutionName = "1zJY9v3KFENX698GSOl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolutionsControllerSolution(ctx, "solutionsControllerSolution", &migrate.SolutionsControllerSolutionArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			Properties: &migrate.SolutionPropertiesArgs{
 * 				CleanupState: pulumi.String(migrate.CleanupStateNone),
 * 				Details: &migrate.SolutionDetailsArgs{
 * 					AssessmentCount: pulumi.Int(7),
 * 					ExtendedDetails: pulumi.StringMap{
 * 						"key9031": pulumi.String("ombnjq"),
 * 					},
 * 					GroupCount: pulumi.Int(30),
 * 				},
 * 				Goal:    pulumi.String(migrate.GoalServers),
 * 				Purpose: pulumi.String(migrate.PurposeDiscovery),
 * 				Status:  pulumi.String(migrate.StatusInactive),
 * 				Tool:    pulumi.String(migrate.ToolServerDiscovery),
 * 			},
 * 			ResourceGroupName: pulumi.String("rghubmigrate"),
 * 			SolutionName:      pulumi.String("1zJY9v3KFENX698GSOl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolution;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs;
 * import com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solutionsControllerSolution = new SolutionsControllerSolution("solutionsControllerSolution", SolutionsControllerSolutionArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .properties(SolutionPropertiesArgs.builder()
 *                 .cleanupState("None")
 *                 .details(SolutionDetailsArgs.builder()
 *                     .assessmentCount(7)
 *                     .extendedDetails(Map.of("key9031", "ombnjq"))
 *                     .groupCount(30)
 *                     .build())
 *                 .goal("Servers")
 *                 .purpose("Discovery")
 *                 .status("Inactive")
 *                 .tool("ServerDiscovery")
 *                 .build())
 *             .resourceGroupName("rghubmigrate")
 *             .solutionName("1zJY9v3KFENX698GSOl")
 *             .build());
 *     }
 * }
 * ```
 * ### SolutionsController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solutionsControllerSolution = new AzureNative.Migrate.SolutionsControllerSolution("solutionsControllerSolution", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         ResourceGroupName = "rghubmigrate",
 *         SolutionName = "1zJY9v3KFENX698GSOl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolutionsControllerSolution(ctx, "solutionsControllerSolution", &migrate.SolutionsControllerSolutionArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 			SolutionName:       pulumi.String("1zJY9v3KFENX698GSOl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolution;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solutionsControllerSolution = new SolutionsControllerSolution("solutionsControllerSolution", SolutionsControllerSolutionArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .resourceGroupName("rghubmigrate")
 *             .solutionName("1zJY9v3KFENX698GSOl")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SolutionsControllerSolution knoffrknza /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/solutions/{solutionName}
 * ```
 */
public class SolutionsControllerSolution internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.SolutionsControllerSolution,
) : KotlinCustomResource(javaResource, SolutionsControllerSolutionMapper) {
    /**
     * Gets or sets the ETAG for optimistic concurrency control.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the name of this REST resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the properties of the solution.
     */
    public val properties: Output<SolutionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Gets the type of this REST resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SolutionsControllerSolutionMapper : ResourceMapper<SolutionsControllerSolution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.SolutionsControllerSolution::class == javaResource::class

    override fun map(javaResource: Resource): SolutionsControllerSolution =
        SolutionsControllerSolution(
            javaResource as
                com.pulumi.azurenative.migrate.SolutionsControllerSolution,
        )
}

/**
 * @see [SolutionsControllerSolution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SolutionsControllerSolution].
 */
public suspend fun solutionsControllerSolution(
    name: String,
    block: suspend SolutionsControllerSolutionResourceBuilder.() -> Unit,
):
    SolutionsControllerSolution {
    val builder = SolutionsControllerSolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SolutionsControllerSolution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun solutionsControllerSolution(name: String): SolutionsControllerSolution {
    val builder = SolutionsControllerSolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
