@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.SolutionPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.SolutionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Solution REST Resource.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### SolutionsController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solutionsControllerSolution = new AzureNative.Migrate.SolutionsControllerSolution("solutionsControllerSolution", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         Properties = new AzureNative.Migrate.Inputs.SolutionPropertiesArgs
 *         {
 *             CleanupState = AzureNative.Migrate.CleanupState.None,
 *             Details = new AzureNative.Migrate.Inputs.SolutionDetailsArgs
 *             {
 *                 AssessmentCount = 7,
 *                 ExtendedDetails =
 *                 {
 *                     { "key9031", "ombnjq" },
 *                 },
 *                 GroupCount = 30,
 *             },
 *             Goal = AzureNative.Migrate.Goal.Servers,
 *             Purpose = AzureNative.Migrate.Purpose.Discovery,
 *             Status = AzureNative.Migrate.Status.Inactive,
 *             Tool = AzureNative.Migrate.Tool.ServerDiscovery,
 *         },
 *         ResourceGroupName = "rghubmigrate",
 *         SolutionName = "1zJY9v3KFENX698GSOl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolutionsControllerSolution(ctx, "solutionsControllerSolution", &migrate.SolutionsControllerSolutionArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			Properties: &migrate.SolutionPropertiesArgs{
 * 				CleanupState: pulumi.String(migrate.CleanupStateNone),
 * 				Details: &migrate.SolutionDetailsArgs{
 * 					AssessmentCount: pulumi.Int(7),
 * 					ExtendedDetails: pulumi.StringMap{
 * 						"key9031": pulumi.String("ombnjq"),
 * 					},
 * 					GroupCount: pulumi.Int(30),
 * 				},
 * 				Goal:    pulumi.String(migrate.GoalServers),
 * 				Purpose: pulumi.String(migrate.PurposeDiscovery),
 * 				Status:  pulumi.String(migrate.StatusInactive),
 * 				Tool:    pulumi.String(migrate.ToolServerDiscovery),
 * 			},
 * 			ResourceGroupName: pulumi.String("rghubmigrate"),
 * 			SolutionName:      pulumi.String("1zJY9v3KFENX698GSOl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolution;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs;
 * import com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs;
 * import com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solutionsControllerSolution = new SolutionsControllerSolution("solutionsControllerSolution", SolutionsControllerSolutionArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .properties(SolutionPropertiesArgs.builder()
 *                 .cleanupState("None")
 *                 .details(SolutionDetailsArgs.builder()
 *                     .assessmentCount(7)
 *                     .extendedDetails(Map.of("key9031", "ombnjq"))
 *                     .groupCount(30)
 *                     .build())
 *                 .goal("Servers")
 *                 .purpose("Discovery")
 *                 .status("Inactive")
 *                 .tool("ServerDiscovery")
 *                 .build())
 *             .resourceGroupName("rghubmigrate")
 *             .solutionName("1zJY9v3KFENX698GSOl")
 *             .build());
 *     }
 * }
 * ```
 * ### SolutionsController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solutionsControllerSolution = new AzureNative.Migrate.SolutionsControllerSolution("solutionsControllerSolution", new()
 *     {
 *         MigrateProjectName = "1GQwlI-",
 *         ResourceGroupName = "rghubmigrate",
 *         SolutionName = "1zJY9v3KFENX698GSOl",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSolutionsControllerSolution(ctx, "solutionsControllerSolution", &migrate.SolutionsControllerSolutionArgs{
 * 			MigrateProjectName: pulumi.String("1GQwlI-"),
 * 			ResourceGroupName:  pulumi.String("rghubmigrate"),
 * 			SolutionName:       pulumi.String("1zJY9v3KFENX698GSOl"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolution;
 * import com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solutionsControllerSolution = new SolutionsControllerSolution("solutionsControllerSolution", SolutionsControllerSolutionArgs.builder()
 *             .migrateProjectName("1GQwlI-")
 *             .resourceGroupName("rghubmigrate")
 *             .solutionName("1zJY9v3KFENX698GSOl")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SolutionsControllerSolution knoffrknza /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}/solutions/{solutionName}
 * ```
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property properties Gets or sets the properties of the solution.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property solutionName Unique name of a migration solution within a migrate project.
 */
public data class SolutionsControllerSolutionArgs(
    public val migrateProjectName: Output<String>? = null,
    public val properties: Output<SolutionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val solutionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs =
        com.pulumi.azurenative.migrate.SolutionsControllerSolutionArgs.builder()
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .solutionName(solutionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionsControllerSolutionArgs].
 */
@PulumiTagMarker
public class SolutionsControllerSolutionArgsBuilder internal constructor() {
    private var migrateProjectName: Output<String>? = null

    private var properties: Output<SolutionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var solutionName: Output<String>? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("gikfexbudxnsokvm")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Gets or sets the properties of the solution.
     */
    @JvmName("pmmwbdeirowhqsuy")
    public suspend fun properties(`value`: Output<SolutionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("shhfbnhjfmjynpeh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of a migration solution within a migrate project.
     */
    @JvmName("bdllyydvwstfqvwt")
    public suspend fun solutionName(`value`: Output<String>) {
        this.solutionName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("oonxexmywutchyhi")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Gets or sets the properties of the solution.
     */
    @JvmName("vgtgktdwuqoiclir")
    public suspend fun properties(`value`: SolutionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the properties of the solution.
     */
    @JvmName("fudfaresofuwxefs")
    public suspend fun properties(argument: suspend SolutionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cvggqvpxuduvcvmg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a migration solution within a migrate project.
     */
    @JvmName("phckgkadkhdhsfqm")
    public suspend fun solutionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionName = mapped
    }

    internal fun build(): SolutionsControllerSolutionArgs = SolutionsControllerSolutionArgs(
        migrateProjectName = migrateProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        solutionName = solutionName,
    )
}
