@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the Azure Storage Redundancy. Example: Locally Redundant Storage.
 */
public enum class AzureStorageRedundancy(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy> {
    Unknown(com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy.Unknown),
    LocallyRedundant(com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy.LocallyRedundant),
    ZoneRedundant(com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy.ZoneRedundant),
    GeoRedundant(com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy.GeoRedundant),
    ReadAccessGeoRedundant(com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy.ReadAccessGeoRedundant),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AzureStorageRedundancy):
            AzureStorageRedundancy = AzureStorageRedundancy.values().first { it.javaValue == javaType }
    }
}
