@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets azure VM category.
 */
public enum class AzureVmCategory(
    public val javaValue: com.pulumi.azurenative.migrate.enums.AzureVmCategory,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.AzureVmCategory> {
    /**
     * Indicates All categories of VM.
     */
    All(com.pulumi.azurenative.migrate.enums.AzureVmCategory.All),

    /**
     * Compute Optimized.
     */
    ComputeOptimized(com.pulumi.azurenative.migrate.enums.AzureVmCategory.ComputeOptimized),

    /**
     * General Purpose.
     */
    GeneralPurpose(com.pulumi.azurenative.migrate.enums.AzureVmCategory.GeneralPurpose),

    /**
     * GPU Optimized.
     */
    GpuOptimized(com.pulumi.azurenative.migrate.enums.AzureVmCategory.GpuOptimized),

    /**
     * High Performance Compute.
     */
    HighPerformanceCompute(com.pulumi.azurenative.migrate.enums.AzureVmCategory.HighPerformanceCompute),

    /**
     * Memory Optimized.
     */
    MemoryOptimized(com.pulumi.azurenative.migrate.enums.AzureVmCategory.MemoryOptimized),

    /**
     * Storage Optimized.
     */
    StorageOptimized(com.pulumi.azurenative.migrate.enums.AzureVmCategory.StorageOptimized),

    /**
     * Isolated VM.
     */
    Isolated(com.pulumi.azurenative.migrate.enums.AzureVmCategory.Isolated),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.AzureVmCategory = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.AzureVmCategory):
            AzureVmCategory = AzureVmCategory.values().first { it.javaValue == javaType }
    }
}
