@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * VSphere licence type.
 */
public enum class LicenseType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.LicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.LicenseType> {
    /**
     * Unknown License.
     */
    Unknown(com.pulumi.azurenative.migrate.enums.LicenseType.Unknown),

    /**
     * VSphereStandard License.
     */
    VSphereStandard(com.pulumi.azurenative.migrate.enums.LicenseType.VSphereStandard),

    /**
     * VSphereEnterprisePlus License.
     */
    VSphereEnterprisePlus(com.pulumi.azurenative.migrate.enums.LicenseType.VSphereEnterprisePlus),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.LicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.LicenseType): LicenseType =
            LicenseType.values().first { it.javaValue == javaType }
    }
}
