@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the deployment target platform.
 */
public enum class WorkloadDeploymentTarget(
    public val javaValue: com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget> {
    AzureKubernetesService(com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget.AzureKubernetesService),
    AzureAppServiceContainer(com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget.AzureAppServiceContainer),
    AzureAppServiceNative(com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget.AzureAppServiceNative),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.WorkloadDeploymentTarget):
            WorkloadDeploymentTarget =
            WorkloadDeploymentTarget.values().first { it.javaValue == javaType }
    }
}
